/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.centrality;

import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.config.WriteConfig;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.write.NodePropertyExporter;
import org.neo4j.graphalgo.results.AbstractResultBuilder;
import org.neo4j.graphalgo.results.CentralityResult;
import org.neo4j.graphalgo.results.CentralityScore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;

public final class CentralityUtils {
    private CentralityUtils() {
    }

    public static <R> void write(GraphDatabaseAPI api, Log log, IdMapping graph, TerminationFlag terminationFlag, CentralityResult result, WriteConfig configuration, AbstractResultBuilder<R> statsBuilder) {
        log.debug("Writing results");
        String propertyName = configuration.writeProperty();
        try (ProgressTimer ignored = statsBuilder.timeWrite();){
            NodePropertyExporter exporter = (NodePropertyExporter)NodePropertyExporter.of((GraphDatabaseAPI)api, (IdMapping)graph, (TerminationFlag)terminationFlag).withLog(log).parallel(Pools.DEFAULT, configuration.writeConcurrency()).build();
            result.export(propertyName, exporter);
        }
        statsBuilder.withWriteProperty(propertyName);
    }

    public static Stream<CentralityScore> streamResults(Graph graph, CentralityResult scores) {
        return LongStream.range(0L, graph.nodeCount()).mapToObj(i -> {
            long nodeId = graph.toOriginalNodeId(i);
            return new CentralityScore(nodeId, Double.valueOf(scores.score(i)));
        });
    }
}

