/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.catalog;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.neo4j.graphalgo.BaseProc;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.config.BaseConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.loading.GraphStoreCatalog;
import org.neo4j.graphalgo.core.utils.export.NeoExport;
import org.neo4j.graphalgo.core.utils.export.NeoExportConfig;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class GraphExportProc
extends BaseProc {
    @Procedure(name="gds.alpha.graph.export", mode=Mode.READ)
    @Description(value="Exports a named graph into a new Neo4j database.")
    public Stream<GraphExportResult> create(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        CypherMapWrapper cypherConfig = CypherMapWrapper.create(configuration);
        NeoExportConfig config = NeoExportConfig.of((String)this.getUsername(), (CypherMapWrapper)cypherConfig);
        this.validateConfig(cypherConfig, (BaseConfig)config);
        GraphExportResult result = (GraphExportResult)this.runWithExceptionLogging("Graph creation failed", () -> {
            Graph graph = GraphStoreCatalog.get((String)this.getUsername(), (String)graphName).getGraph();
            NeoExport neoExport = new NeoExport(graph, config);
            long start = System.nanoTime();
            neoExport.run();
            long end = System.nanoTime();
            return new GraphExportResult(graphName, config.storeDir(), config.dbName(), graph.nodeCount(), graph.relationshipCount(), (long)graph.availableNodeProperties().size() * graph.nodeCount(), TimeUnit.NANOSECONDS.toMillis(end - start));
        });
        return Stream.of(result);
    }

    public static class GraphExportResult {
        public final String graphName;
        public final String storeDir;
        public final String dbName;
        public final long nodeCount;
        public final long relationshipCount;
        public final long nodePropertyCount;
        public final long writeMillis;

        public GraphExportResult(String graphName, String storeDir, String dbName, long nodeCount, long relationshipCount, long nodePropertyCount, long writeMillis) {
            this.graphName = graphName;
            this.storeDir = storeDir;
            this.dbName = dbName;
            this.nodeCount = nodeCount;
            this.relationshipCount = relationshipCount;
            this.nodePropertyCount = nodePropertyCount;
            this.writeMillis = writeMillis;
        }
    }
}

