/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo;

import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class IsFiniteFunc {
    @UserFunction(value="gds.util.isFinite")
    @Description(value="CALL gds.util.isFinite(value) - Return true iff the given argument is a finite value (not \u00b1Infinity, NaN, or null).")
    public boolean isFinite(@Name(value="value") Number value) {
        return value != null && Double.isFinite(value.doubleValue());
    }

    @UserFunction(value="gds.util.isInfinite")
    @Description(value="CALL gds.util.isInfinite(value) - Return true iff the given argument is not a finite value (not \u00b1Infinity, NaN, or null).")
    public boolean isInfinite(@Name(value="value") Number value) {
        return value == null || !Double.isFinite(value.doubleValue());
    }

    @UserFunction(value="gds.util.infinity")
    @Description(value="CALL gds.util.infinity() - Return infinity as a Cypher value.")
    public double Infinity() {
        return Double.POSITIVE_INFINITY;
    }

    @UserFunction(value="gds.util.NaN")
    @Description(value="CALL gds.util.NaN() - Returns NaN as a Cypher value.")
    public double NaN() {
        return Double.NaN;
    }
}

