/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.shortestpaths;

import java.util.Optional;
import org.immutables.value.Value;
import org.neo4j.graphalgo.annotation.Configuration;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.config.RelationshipWeightConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.shortestpaths.ShortestPathAStarConfigImpl;
import org.neo4j.graphdb.Node;

@Configuration(value="ShortestPathAStarConfigImpl")
public interface ShortestPathAStarConfig
extends AlgoBaseConfig,
RelationshipWeightConfig {
    @Value.Default
    default public String propertyKeyLat() {
        return "latitude";
    }

    @Value.Default
    default public String propertyKeyLon() {
        return "longitude";
    }

    @Configuration.ConvertWith(value="nodeId")
    @Configuration.Key(value="startNode")
    public long startNodeId();

    @Configuration.ConvertWith(value="nodeId")
    @Configuration.Key(value="endNode")
    public long endNodeId();

    public static long nodeId(Node node) {
        return node.getId();
    }

    public static ShortestPathAStarConfig of(Optional<String> graphName, Optional<GraphCreateConfig> implicitCreateConfig, String username, CypherMapWrapper userInput) {
        return new ShortestPathAStarConfigImpl(graphName, implicitCreateConfig, username, userInput);
    }
}

