/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.shortestpaths;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.eclipse.collections.api.tuple.Pair;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.AlphaAlgorithmFactory;
import org.neo4j.graphalgo.api.FilterGraph;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.api.RelationshipProperties;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.Pointer;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.impl.shortestpaths.WeightedPathExporter;
import org.neo4j.graphalgo.impl.shortestpaths.YensKShortestPaths;
import org.neo4j.graphalgo.impl.shortestpaths.YensKShortestPathsConfig;
import org.neo4j.graphalgo.impl.shortestpaths.YensKShortestPathsConfigImpl;
import org.neo4j.graphalgo.impl.walking.WalkPath;
import org.neo4j.graphalgo.results.AbstractResultBuilder;
import org.neo4j.graphdb.Path;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class KShortestPathsProc
extends AlgoBaseProc<YensKShortestPaths, YensKShortestPaths, YensKShortestPathsConfig> {
    private static final String DESCRIPTION = "Yen's K-shortest paths algorithm computes single-source K-shortest loopless paths for a graph with non-negative relationship weights.";

    @Procedure(name="gds.alpha.kShortestPaths.stream", mode=Mode.READ)
    @Description(value="Yen's K-shortest paths algorithm computes single-source K-shortest loopless paths for a graph with non-negative relationship weights.")
    public Stream<KspStreamResult> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        KspResult.Builder builder = new KspResult.Builder();
        builder.setCreateMillis(computationResult.createMillis());
        builder.setComputeMillis(computationResult.computeMillis());
        Graph graph = computationResult.graph();
        YensKShortestPaths algorithm = (YensKShortestPaths)computationResult.algorithm();
        YensKShortestPathsConfig config = (YensKShortestPathsConfig)computationResult.config();
        if (graph.isEmpty() || algorithm == null) {
            graph.release();
            return Stream.empty();
        }
        builder.withResultCount(algorithm.getPaths().size());
        boolean returnPath = config.path();
        Pointer.IntPointer counter = Pointer.wrap((int)0);
        return algorithm.getPaths().stream().map(weightedPath -> {
            long[] nodeIds = new long[weightedPath.size()];
            AtomicInteger count = new AtomicInteger(0);
            weightedPath.forEach(i -> {
                long originalNodeId;
                nodeIds[count.getAndIncrement()] = originalNodeId = graph.toOriginalNodeId((long)i);
                return true;
            });
            count.set(0);
            double[] costs = new double[weightedPath.size() - 1];
            weightedPath.forEachEdge((sourceNode, targetNode) -> {
                double cost;
                costs[count.getAndIncrement()] = cost = graph.relationshipProperty((long)sourceNode, (long)targetNode, 1.0);
            });
            Path path = null;
            if (returnPath) {
                path = config.relationshipWeightProperty() != null ? WalkPath.toPath((GraphDatabaseAPI)this.api, (long[])nodeIds, (double[])costs) : WalkPath.toPath((GraphDatabaseAPI)this.api, (long[])nodeIds);
            }
            return new KspStreamResult(counter.v++, nodeIds, path, costs);
        });
    }

    protected Pair<YensKShortestPathsConfig, Optional<String>> processInput(Object graphNameOrConfig, Map<String, Object> configuration) {
        return super.processInput(graphNameOrConfig, configuration);
    }

    @Procedure(value="gds.alpha.kShortestPaths.write", mode=Mode.WRITE)
    @Description(value="Yen's K-shortest paths algorithm computes single-source K-shortest loopless paths for a graph with non-negative relationship weights.")
    public Stream<KspResult> write(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        KspResult.Builder builder = new KspResult.Builder();
        builder.setCreateMillis(computationResult.createMillis());
        builder.setComputeMillis(computationResult.computeMillis());
        Graph graph = computationResult.graph();
        YensKShortestPaths algorithm = (YensKShortestPaths)computationResult.algorithm();
        YensKShortestPathsConfig config = (YensKShortestPathsConfig)computationResult.config();
        if (graph.isEmpty() || algorithm == null) {
            ReleaseBlockedGraph.runRelease(graph);
            return Stream.of(builder.build());
        }
        builder.withResultCount(algorithm.getPaths().size());
        try (ProgressTimer timer = builder.timeWrite();){
            new WeightedPathExporter(this.api, Pools.DEFAULT, (IdMapping)graph, (RelationshipProperties)graph, config.writePropertyPrefix(), config.relationshipWriteProperty()).export(algorithm.getPaths());
        }
        ReleaseBlockedGraph.runRelease(graph);
        return Stream.of(builder.build());
    }

    protected YensKShortestPathsConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return new YensKShortestPathsConfigImpl(graphName, maybeImplicitCreate, username, config);
    }

    protected Graph createGraph(Pair<YensKShortestPathsConfig, Optional<String>> configAndName) {
        Graph graph = super.createGraph(configAndName);
        return new ReleaseBlockedGraph(graph);
    }

    protected AlgorithmFactory<YensKShortestPaths, YensKShortestPathsConfig> algorithmFactory(YensKShortestPathsConfig config) {
        return new AlphaAlgorithmFactory<YensKShortestPaths, YensKShortestPathsConfig>(){

            public YensKShortestPaths build(Graph graph, YensKShortestPathsConfig configuration, AllocationTracker tracker, Log log) {
                return new YensKShortestPaths(graph, configuration.startNode(), configuration.endNode(), configuration.k(), configuration.maxDepth());
            }
        };
    }

    private static final class ReleaseBlockedGraph
    extends FilterGraph {
        static void runRelease(Graph graph) {
            if (graph instanceof ReleaseBlockedGraph) {
                ((ReleaseBlockedGraph)graph).actuallyRelease();
            } else {
                graph.release();
            }
        }

        public ReleaseBlockedGraph(Graph graph) {
            super(graph);
        }

        public void release() {
        }

        void actuallyRelease() {
            super.release();
        }
    }

    public static class KspResult {
        public final long createMillis;
        public final long evalMillis;
        public final long writeMillis;
        public final long resultCount;

        public KspResult(long createMillis, long evalMillis, long writeMillis, long resultCount) {
            this.createMillis = createMillis;
            this.evalMillis = evalMillis;
            this.writeMillis = writeMillis;
            this.resultCount = resultCount;
        }

        public static class Builder
        extends AbstractResultBuilder<KspResult> {
            private int resultCount;

            public Builder withResultCount(int resultCount) {
                this.resultCount = resultCount;
                return this;
            }

            public KspResult build() {
                return new KspResult(this.createMillis, this.computeMillis, this.writeMillis, this.resultCount);
            }
        }
    }

    public static class KspStreamResult {
        public Long index;
        public Long sourceNodeId;
        public Long targetNodeId;
        public List<Long> nodeIds;
        public List<Double> costs;
        public Path path;

        public KspStreamResult(long index, long[] nodes, Path path, double[] costs) {
            this.index = index;
            this.sourceNodeId = nodes.length > 0 ? Long.valueOf(nodes[0]) : null;
            this.targetNodeId = nodes.length > 0 ? Long.valueOf(nodes[nodes.length - 1]) : null;
            this.nodeIds = new ArrayList<Long>(nodes.length);
            for (long node : nodes) {
                this.nodeIds.add(node);
            }
            this.costs = new ArrayList<Double>(costs.length);
            for (double cost : costs) {
                this.costs.add(cost);
            }
            this.path = path;
        }
    }
}

