/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.shortestpaths;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.AlphaAlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.impl.msbfs.MSBFSASPAlgorithm;
import org.neo4j.graphalgo.impl.msbfs.MSBFSAllShortestPaths;
import org.neo4j.graphalgo.impl.msbfs.WeightedAllShortestPaths;
import org.neo4j.graphalgo.shortestpaths.AllShortestPathsConfig;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class AllShortestPathsProc
extends AlgoBaseProc<MSBFSASPAlgorithm, Stream<WeightedAllShortestPaths.Result>, AllShortestPathsConfig> {
    private static final String DESCRIPTION = "The All Pairs Shortest Path (APSP) calculates the shortest (weighted) path between all pairs of nodes.";

    @Procedure(name="gds.alpha.allShortestPaths.stream", mode=Mode.READ)
    @Description(value="The All Pairs Shortest Path (APSP) calculates the shortest (weighted) path between all pairs of nodes.")
    public Stream<WeightedAllShortestPaths.Result> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration, false, false);
        if (computationResult.isGraphEmpty()) {
            computationResult.graph().release();
            return Stream.empty();
        }
        return (Stream)computationResult.result();
    }

    protected AllShortestPathsConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return AllShortestPathsConfig.of(username, graphName, maybeImplicitCreate, config);
    }

    protected AlgorithmFactory<MSBFSASPAlgorithm, AllShortestPathsConfig> algorithmFactory(final AllShortestPathsConfig config) {
        return new AlphaAlgorithmFactory<MSBFSASPAlgorithm, AllShortestPathsConfig>(){

            public MSBFSASPAlgorithm build(Graph graph, AllShortestPathsConfig configuration, AllocationTracker tracker, Log log) {
                if (config.relationshipWeightProperty() != null) {
                    return (MSBFSASPAlgorithm)((MSBFSASPAlgorithm)new WeightedAllShortestPaths(graph, Pools.DEFAULT, configuration.concurrency()).withProgressLogger(ProgressLogger.wrap((Log)log, (String)"WeightedAllShortestPaths)"))).withTerminationFlag(TerminationFlag.wrap((KernelTransaction)AllShortestPathsProc.this.transaction));
                }
                return (MSBFSASPAlgorithm)((MSBFSASPAlgorithm)new MSBFSAllShortestPaths(graph, tracker, configuration.concurrency(), Pools.DEFAULT).withProgressLogger(ProgressLogger.wrap((Log)log, (String)"AllShortestPaths(MultiSource)"))).withTerminationFlag(TerminationFlag.wrap((KernelTransaction)AllShortestPathsProc.this.transaction));
            }
        };
    }
}

