/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.linkprediction;

import java.util.Map;
import java.util.Set;
import org.neo4j.graphalgo.BaseProc;
import org.neo4j.graphalgo.core.ProcedureConfiguration;
import org.neo4j.graphalgo.linkprediction.NeighborsFinder;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class LinkPredictionFunc
extends BaseProc {
    @UserFunction(value="gds.alpha.linkprediction.adamicAdar")
    @Description(value="Given two nodes, calculate Adamic Adar similarity")
    public double adamicAdarSimilarity(@Name(value="node1") Node node1, @Name(value="node2") Node node2, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        if (node1 == null || node2 == null) {
            throw new RuntimeException("Nodes must not be null");
        }
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config, (String)this.getUsername());
        RelationshipType relationshipType = configuration.getRelationship();
        Direction direction = configuration.getDirection(Direction.BOTH);
        Set<Node> neighbors = new NeighborsFinder(this.api).findCommonNeighbors(node1, node2, relationshipType, direction);
        return neighbors.stream().mapToDouble(nb -> 1.0 / Math.log(this.degree((Node)nb, relationshipType, direction))).sum();
    }

    @UserFunction(value="gds.alpha.linkprediction.resourceAllocation")
    @Description(value="Given two nodes, calculate Resource Allocation similarity")
    public double resourceAllocationSimilarity(@Name(value="node1") Node node1, @Name(value="node2") Node node2, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        if (node1 == null || node2 == null) {
            throw new RuntimeException("Nodes must not be null");
        }
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config, (String)this.getUsername());
        RelationshipType relationshipType = configuration.getRelationship();
        Direction direction = configuration.getDirection(Direction.BOTH);
        Set<Node> neighbors = new NeighborsFinder(this.api).findCommonNeighbors(node1, node2, relationshipType, direction);
        return neighbors.stream().mapToDouble(nb -> 1.0 / (double)this.degree((Node)nb, relationshipType, direction)).sum();
    }

    @UserFunction(value="gds.alpha.linkprediction.commonNeighbors")
    @Description(value="Given two nodes, returns the number of common neighbors")
    public double commonNeighbors(@Name(value="node1") Node node1, @Name(value="node2") Node node2, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        if (node1 == null || node2 == null) {
            throw new RuntimeException("Nodes must not be null");
        }
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config, (String)this.getUsername());
        RelationshipType relationshipType = configuration.getRelationship();
        Direction direction = configuration.getDirection(Direction.BOTH);
        Set<Node> neighbors = new NeighborsFinder(this.api).findCommonNeighbors(node1, node2, relationshipType, direction);
        return neighbors.size();
    }

    @UserFunction(value="gds.alpha.linkprediction.preferentialAttachment")
    @Description(value="Given two nodes, calculate Preferential Attachment")
    public double preferentialAttachment(@Name(value="node1") Node node1, @Name(value="node2") Node node2, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        if (node1 == null || node2 == null) {
            throw new RuntimeException("Nodes must not be null");
        }
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config, (String)this.getUsername());
        RelationshipType relationshipType = configuration.getRelationship();
        Direction direction = configuration.getDirection(Direction.BOTH);
        return this.degree(node1, relationshipType, direction) * this.degree(node2, relationshipType, direction);
    }

    @UserFunction(value="gds.alpha.linkprediction.totalNeighbors")
    @Description(value="Given two nodes, calculate Total Neighbors")
    public double totalNeighbors(@Name(value="node1") Node node1, @Name(value="node2") Node node2, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config, (String)this.getUsername());
        RelationshipType relationshipType = configuration.getRelationship();
        Direction direction = configuration.getDirection(Direction.BOTH);
        NeighborsFinder neighborsFinder = new NeighborsFinder(this.api);
        return neighborsFinder.findNeighbors(node1, node2, relationshipType, direction).size();
    }

    @UserFunction(value="gds.alpha.linkprediction.sameCommunity")
    @Description(value="Given two nodes, indicates if they have the same community")
    public double sameCommunity(@Name(value="node1") Node node1, @Name(value="node2") Node node2, @Name(value="communityProperty", defaultValue="community") String communityProperty) {
        if (!node1.hasProperty(communityProperty) || !node2.hasProperty(communityProperty)) {
            return 0.0;
        }
        return node1.getProperty(communityProperty).equals(node2.getProperty(communityProperty)) ? 1.0 : 0.0;
    }

    private int degree(Node node, RelationshipType relationshipType, Direction direction) {
        return relationshipType == null ? node.getDegree(direction) : node.getDegree(relationshipType, direction);
    }
}

