/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.centrality.eigenvector;

import java.util.Optional;
import org.immutables.value.Value;
import org.neo4j.graphalgo.annotation.Configuration;
import org.neo4j.graphalgo.annotation.ValueClass;
import org.neo4j.graphalgo.centrality.eigenvector.EigenvectorCentralityConfigImpl;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.config.IterationsConfig;
import org.neo4j.graphalgo.config.RelationshipWeightConfig;
import org.neo4j.graphalgo.config.SourceNodesConfig;
import org.neo4j.graphalgo.config.WriteConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;

@ValueClass
@Configuration(value="EigenvectorCentralityConfigImpl")
public interface EigenvectorCentralityConfig
extends AlgoBaseConfig,
IterationsConfig,
SourceNodesConfig,
WriteConfig,
RelationshipWeightConfig {
    @Value.Default
    default public int maxIterations() {
        return 20;
    }

    @Value.Default
    default public String writeProperty() {
        return "eigenvector";
    }

    @Value.Default
    default public String normalization() {
        return "NONE";
    }

    public static EigenvectorCentralityConfig of(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper userInput) {
        return new EigenvectorCentralityConfigImpl(graphName, maybeImplicitCreate, username, userInput);
    }
}

