/*
 * Decompiled with CFR 0.152.
 */
package org.nekosoft.utils.crawlerdetect;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.nekosoft.utils.CrawlerDetect;
import org.nekosoft.utils.crawlerdetect.AbstractDataProvider;

public class Detector
implements CrawlerDetect {
    private AbstractDataProvider crawlerPatterns;
    private List<Pattern> crawlerPatternRE;
    private AbstractDataProvider headersToCheck;
    private AbstractDataProvider uaExclusions;
    private List<Pattern> uaExclusionsRE;

    public AbstractDataProvider getCrawlerPatterns() {
        return this.crawlerPatterns;
    }

    public void setCrawlerPatterns(AbstractDataProvider crawlerPatterns) {
        this.crawlerPatterns = crawlerPatterns;
        this.crawlerPatternRE = crawlerPatterns.getAllValues().stream().map(s -> Pattern.compile(s, 2)).toList();
    }

    public AbstractDataProvider getHeadersToCheck() {
        return this.headersToCheck;
    }

    public void setHeadersToCheck(AbstractDataProvider headersToCheck) {
        this.headersToCheck = headersToCheck;
    }

    public AbstractDataProvider getUaExclusions() {
        return this.uaExclusions;
    }

    public void setUaExclusions(AbstractDataProvider uaExclusions) {
        this.uaExclusions = uaExclusions;
        this.uaExclusionsRE = uaExclusions.getAllValues().stream().map(s -> Pattern.compile(s, 2)).toList();
    }

    @Override
    public boolean isCrawler(Map<String, String> headers) {
        StringBuilder uaString = new StringBuilder();
        for (String altHeader : this.headersToCheck.getAllValues()) {
            String header = headers.get(altHeader);
            if (header == null) continue;
            uaString.append(" ").append(header);
        }
        return this.isCrawler(uaString.toString());
    }

    @Override
    public boolean isCrawler(String userAgent) {
        if (this.uaExclusionsRE == null || this.crawlerPatternRE == null) {
            throw new IllegalStateException("Cannot check for bots without crawler detection data");
        }
        for (Pattern pattern2 : this.uaExclusionsRE) {
            userAgent = pattern2.matcher(userAgent).replaceAll("");
        }
        String finalUA = userAgent;
        return this.crawlerPatternRE.stream().anyMatch(pattern -> pattern.matcher(finalUA).find());
    }
}

