/*
 * Decompiled with CFR 0.152.
 */
package org.nekosoft.utils.crawlerdetect;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;

public class AbstractDataProvider {
    protected URL source;
    protected List<String> data;

    public AbstractDataProvider(List<String> data) {
        this.data = data;
    }

    public AbstractDataProvider(URL source) throws IOException {
        this.source = source;
        this.reloadData();
    }

    public void reloadData() throws IOException {
        File file;
        URL source = this.source;
        if (source == null) {
            return;
        }
        String baseDir = System.getProperty("crawlerdetect.cfg.baseDir", System.getProperty("java.io.tmpdir"));
        int refreshDays = Integer.parseInt(System.getProperty("crawlerdetect.cfg.refreshDays", "31"));
        Path cacheDir = Path.of(baseDir, "CrawlerDetectCache");
        if (!cacheDir.toFile().isDirectory()) {
            Files.createDirectory(cacheDir, new FileAttribute[0]);
        }
        if ((file = cacheDir.resolve(this.getClass().getName() + ".txt").toFile()).isFile()) {
            BasicFileAttributes attr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            if (refreshDays > 0 && attr.lastModifiedTime().toInstant().isBefore(Instant.now().minus(refreshDays, ChronoUnit.DAYS))) {
                if (!file.delete()) {
                    throw new IllegalStateException("Could not delete cache file " + file);
                }
            } else {
                source = file.toURI().toURL();
            }
        }
        try (InputStream in = source.openStream();){
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            this.data = reader.lines().toList();
        }
        if (!file.exists()) {
            try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), new OpenOption[0]);){
                for (String line : this.data) {
                    writer.write(line);
                    writer.newLine();
                }
            }
        }
    }

    public List<String> getAllValues() {
        return Collections.unmodifiableList(this.data);
    }
}

