/*
 * Decompiled with CFR 0.152.
 */
package org.nekosoft.pdffer.explorer;

import org.nekosoft.pdffer.PdfferProducerBean;
import org.nekosoft.pdffer.exception.PdfferMailerException;
import org.nekosoft.pdffer.explorer.AbstractPdfferExplorerController;
import org.nekosoft.pdffer.mail.PdfferMailerBean;
import org.nekosoft.pdffer.registry.PdfferRegistryBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Profile;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"explorer"})
@ConditionalOnBean(value={PdfferMailerBean.class})
@Profile(value={"pdffer-explorer"})
public class PdfferMailerExplorerController
extends AbstractPdfferExplorerController {
    @Value(value="classpath:org/nekosoft/pdffer/explorer/email.html")
    private Resource emailHtmlTemplate;
    private final PdfferMailerBean mailer;

    public PdfferMailerExplorerController(PdfferProducerBean pdffer, PdfferRegistryBean registry, PdfferMailerBean mailer) {
        super(pdffer, registry);
        this.mailer = mailer;
    }

    @GetMapping(value={"email"})
    @ResponseBody
    public String emailForm() {
        return this.htmlTemplateAsString(this.emailHtmlTemplate, "");
    }

    @PostMapping(value={"email"}, produces={"text/html"})
    @ResponseBody
    public ResponseEntity<String> processEmailForm(@RequestParam(value="pdfTemplatePath") String templatePath, @RequestParam(value="pdfPayload") String payload, @RequestParam(value="sendEmails") String sendEmails, @RequestParam(value="mailSubject") String mailSubject, @RequestParam(value="mailMessage") String mailMessage) {
        try {
            byte[] pdfBytes = this.pdffer.generatePdfDocumentByPathFromJsonString(templatePath, payload);
            this.mailer.sendMessageWithPdfAttachment(sendEmails, mailSubject, mailMessage, pdfBytes, "pdffer.pdf", null, null);
            String body = this.htmlTemplateAsString(this.emailHtmlTemplate, "<p class=\"text-success\">Email with PDF was successfully sent to " + sendEmails + "</p>");
            return new ResponseEntity((Object)body, (HttpStatusCode)HttpStatus.OK);
        }
        catch (PdfferMailerException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        catch (IllegalArgumentException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }
}

