/*
 * Decompiled with CFR 0.152.
 */
package org.nekosoft.pdffer.explorer;

import org.nekosoft.pdffer.PdfferProducerBean;
import org.nekosoft.pdffer.explorer.AbstractPdfferExplorerController;
import org.nekosoft.pdffer.registry.PdfferRegistryBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"explorer"})
@Profile(value={"pdffer-explorer"})
public class PdfferExplorerController
extends AbstractPdfferExplorerController {
    @Value(value="classpath:org/nekosoft/pdffer/explorer/home.html")
    private Resource homeHtmlTemplate;
    @Value(value="classpath:org/nekosoft/pdffer/explorer/download.html")
    private Resource downloadHtmlTemplate;

    public PdfferExplorerController(PdfferProducerBean pdffer, PdfferRegistryBean registry) {
        super(pdffer, registry);
    }

    @GetMapping
    @ResponseBody
    public String homePage() {
        return this.htmlTemplateAsString(this.homeHtmlTemplate, "");
    }

    @GetMapping(value={"download"}, produces={"text/html"})
    @ResponseBody
    public String downloadForm() {
        return this.htmlTemplateAsString(this.downloadHtmlTemplate, "");
    }

    @PostMapping(value={"download"}, produces={"application/pdf"})
    @ResponseBody
    public ResponseEntity<byte[]> processDownloadForm(@RequestParam(value="pdfTemplatePath") String templatePath, @RequestParam(value="pdfPayload") String payload) {
        try {
            byte[] body = this.pdffer.generatePdfDocumentByPathFromJsonString(templatePath, payload);
            return new ResponseEntity((Object)body, (HttpStatusCode)HttpStatus.OK);
        }
        catch (IllegalArgumentException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }
}

