/*
 * Decompiled with CFR 0.152.
 */
package org.nekosoft.pdffer.explorer;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.context.annotation.Profile;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Profile(value={"pdffer-explorer"})
public class PdfferErrorController
implements ErrorController {
    @Value(value="classpath:org/nekosoft/pdffer/explorer/error.html")
    private Resource errorHtmlTemplate;

    private static String htmlTemplateAsString(Resource resource, HttpServletRequest request) {
        String string;
        InputStreamReader reader = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);
        try {
            Integer statusCode = (Integer)request.getAttribute("javax.servlet.error.status_code");
            Exception exception = (Exception)request.getAttribute("javax.servlet.error.exception");
            string = FileCopyUtils.copyToString((Reader)reader).replace("{{status}}", statusCode.toString()).replace("{{exception}}", exception != null ? exception.getMessage() : "-");
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        ((Reader)reader).close();
        return string;
    }

    @RequestMapping(value={"/error"})
    @ResponseBody
    public String handleError(HttpServletRequest request) {
        return PdfferErrorController.htmlTemplateAsString(this.errorHtmlTemplate, request);
    }
}

