/*
 * Decompiled with CFR 0.152.
 */
package org.nekosoft.pdffer.explorer;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.nekosoft.pdffer.PdfferProducerBean;
import org.nekosoft.pdffer.registry.PdfferRegistryBean;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.util.HtmlUtils;

public class AbstractPdfferExplorerController {
    protected final PdfferProducerBean pdffer;
    protected final PdfferRegistryBean registry;

    public AbstractPdfferExplorerController(PdfferProducerBean pdffer, PdfferRegistryBean registry) {
        this.pdffer = pdffer;
        this.registry = registry;
    }

    protected String htmlTemplateAsString(Resource resource, String result) {
        String string;
        InputStreamReader reader = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);
        try {
            String htmlTemplate = FileCopyUtils.copyToString((Reader)reader);
            StringBuilder pdfTemplateHtml = new StringBuilder();
            List templatePaths = this.registry.listTemplatePaths();
            for (String path : templatePaths) {
                pdfTemplateHtml.append("<option value=\"" + HtmlUtils.htmlEscape((String)path) + "\">");
                pdfTemplateHtml.append(HtmlUtils.htmlEscape((String)path));
                pdfTemplateHtml.append("</option>\n");
            }
            string = htmlTemplate.replace("{{result}}", result).replace("{{templates}}", pdfTemplateHtml);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        ((Reader)reader).close();
        return string;
    }
}

