package org.nekosoft.pdffer.explorer;

import org.nekosoft.pdffer.mail.PdfferMailerBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.server.ResponseStatusException;

import static org.nekosoft.pdffer.PdfferCoreConfiguration.PROFILE_EXPLORER;

/**
 * A controller that is made available when PDFfer mailing functionality is not present. It just throws a ResponseStatusException
 * to explain that mailer functionality is not present.
 */
@Controller
@RequestMapping("explorer")
@ConditionalOnMissingBean(PdfferMailerBean.class)
@Profile(PROFILE_EXPLORER)
public class PdfferNoMailerExplorerController {

    /**
     * Controller method mapped to /email (all HTTP methods).
     * It unconditionally fails because this controller is only registered when the required mailer bean is not present.
     *
     * @throws ResponseStatusException an HTTP 417 error response code because the mailer bean is not present
     */
    @RequestMapping("email")
    public void emailForm() {
        throw new ResponseStatusException(HttpStatus.EXPECTATION_FAILED, "Mailer functionality not present");
    }

}
