/*
 * Decompiled with CFR 0.152.
 */
package org.nekosoft.pdffer.web;

import org.nekosoft.pdffer.PdfferProducerBean;
import org.nekosoft.pdffer.web.DownloadRequestData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnWebApplication
@ConditionalOnBean(type={"org.nekosoft.pdffer.PdfferProducerBean"})
@ConditionalOnProperty(name={"pdffer.web.controller.enabled"}, havingValue="true", matchIfMissing=false)
@RequestMapping(value={"${pdffer.web.controller.base_uri:pdffer}"})
public class PdfferController {
    private static Logger logger = LoggerFactory.getLogger(PdfferController.class);
    private final PdfferProducerBean pdfferProducer;

    public PdfferController(PdfferProducerBean pdfferProducer) {
        this.pdfferProducer = pdfferProducer;
    }

    @PostMapping(value={"${pdffer.web.controller.download_uri:download}/{templateId}"})
    public ResponseEntity<byte[]> download(@PathVariable String templateId, @RequestBody DownloadRequestData requestData) {
        try {
            byte[] pdfBytes = this.pdfferProducer.generatePdfDocument(templateId, requestData.getPayload());
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            headers.add("Content-Disposition", "attachment; filename=" + requestData.getFilename());
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength((long)pdfBytes.length).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)pdfBytes);
        }
        catch (RuntimeException e) {
            logger.debug("Bad Request", (Throwable)e);
            return ResponseEntity.badRequest().build();
        }
    }

    @PostMapping(value={"${pdffer.web.controller.save_uri:save}/{templateId}"})
    public void save(@PathVariable String templateId) {
    }
}

