/*
 * Decompiled with CFR 0.152.
 */
package org.nekosoft.pdffer.mail;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.nekosoft.pdffer.exception.MailAddressException;
import org.nekosoft.pdffer.exception.MailMessageException;
import org.nekosoft.pdffer.exception.MailSenderException;
import org.nekosoft.pdffer.props.PdfferMailerProps;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass(name={"org.springframework.mail.javamail.JavaMailSenderImpl"})
@ConditionalOnProperty(name={"pdffer.mailer.enabled"}, havingValue="true", matchIfMissing=false)
public class PdfferMailerBean {
    private final JavaMailSender mailSender;
    private PdfferMailerProps props;

    public PdfferMailerBean(JavaMailSender mailSender, PdfferMailerProps props) {
        this.mailSender = mailSender;
        this.props = props;
    }

    public void sendMessageWithPdfAttachment(String toString, String subject, String text, byte[] attachment, String filename, String sendFrom, String replyTo) throws MailAddressException, MailMessageException, MailSenderException {
        this.sendMessageWithPdfAttachmentToList(Arrays.asList(toString.split(",")), subject, text, attachment, filename, sendFrom, replyTo);
    }

    public void sendMessageWithPdfAttachmentToList(List<String> toList, String subject, String text, byte[] attachment, String filename, String sendFrom, String replyTo) throws MailAddressException, MailMessageException, MailSenderException {
        try {
            ArrayList<InternetAddress> recipients = new ArrayList<InternetAddress>();
            for (String email : toList) {
                recipients.add(new InternetAddress(email.trim()));
            }
            this.sendMessageWithPdfAttachment(recipients, subject, text, attachment, filename, sendFrom, replyTo);
        }
        catch (AddressException e) {
            throw new MailAddressException(e);
        }
    }

    public void sendMessageWithPdfAttachment(List<InternetAddress> to, String subject, String text, byte[] attachment, String filename, String sendFrom, String replyTo) throws MailAddressException, MailMessageException, MailSenderException {
        this.sendMessageWithAttachments(to, subject, text, sendFrom, replyTo, attachment, filename, new Object[0]);
    }

    public void sendMessageWithAttachmentsToList(List<String> toList, String subject, String text, String sendFrom, String replyTo, byte[] pdfAttachment, String pdfFilename, Object ... attachmentsVarargs) throws MailAddressException, MailMessageException, MailSenderException {
        try {
            ArrayList<InternetAddress> recipients = new ArrayList<InternetAddress>();
            for (String email : toList) {
                recipients.add(new InternetAddress(email.trim()));
            }
            this.sendMessageWithAttachments(recipients, subject, text, sendFrom, replyTo, pdfAttachment, pdfFilename, attachmentsVarargs);
        }
        catch (AddressException e) {
            throw new MailAddressException(e);
        }
    }

    public void sendMessageWithAttachments(List<InternetAddress> to, String subject, String text, String sendFrom, String replyTo, byte[] pdfAttachment, String pdfFilename, Object ... attachmentsVarargs) throws MailAddressException, MailMessageException, MailSenderException {
        if (attachmentsVarargs.length % 3 != 0) {
            throw new IllegalArgumentException("Attachments must be in groups of 3: bytes[], filename, mimeType");
        }
        MimeMessage message = this.mailSender.createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setFrom(Objects.requireNonNullElseGet(sendFrom, () -> String.format("\"%s\" <%s>", this.props.getSendFrom().getName(), this.props.getSendFrom().getAddress())));
            helper.setReplyTo(Objects.requireNonNullElseGet(replyTo, () -> String.format("\"%s\" <%s>", this.props.getReplyTo().getName(), this.props.getReplyTo().getAddress())));
            helper.setTo(to.toArray(new InternetAddress[0]));
            helper.setSubject(subject);
            helper.setText(text);
            helper.addAttachment(pdfFilename, (InputStreamSource)new ByteArrayResource(pdfAttachment), "application/pdf");
            for (int i = 0; i < attachmentsVarargs.length; i += 3) {
                Object dataObj = attachmentsVarargs[i];
                Object filenameObj = attachmentsVarargs[i + 1];
                Object mimeTypeObj = attachmentsVarargs[i + 2];
                if (!(dataObj instanceof byte[])) {
                    throw new IllegalArgumentException(String.format("Expected byte[] at position %d, got %s", i, dataObj.getClass().getSimpleName()));
                }
                byte[] data = (byte[])dataObj;
                if (!(filenameObj instanceof String)) {
                    throw new IllegalArgumentException(String.format("Expected String (filename) at position %d, got %s", i + 1, filenameObj.getClass().getSimpleName()));
                }
                String filename = (String)filenameObj;
                if (!(mimeTypeObj instanceof String)) {
                    throw new IllegalArgumentException(String.format("Expected String (mimeType) at position %d, got %s", i + 2, mimeTypeObj.getClass().getSimpleName()));
                }
                String mimeType = (String)mimeTypeObj;
                helper.addAttachment(filename, (InputStreamSource)new ByteArrayResource(data), mimeType);
            }
        }
        catch (AddressException e) {
            throw new MailAddressException(e);
        }
        catch (MessagingException e) {
            throw new MailMessageException(e);
        }
        try {
            this.mailSender.send(message);
        }
        catch (MailException e) {
            throw new MailSenderException(e);
        }
    }
}

