package org.nekosoft.pdffer.props;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.ConstructorBinding;

/**
 * A Property POJO that reflects the configuration of the mailer controller.
 */
@ConfigurationProperties(prefix = "pdffer.mailer.controller")
public class PdfferMailerControllerProps {
    // field declarations
    private final boolean enabled;
    private final String baseUri;
    private final String mailUri;

    /**
     * Instantiates a new PDFfer mailer controller props.
     *
     * @param baseUri the base URL of the controller
     * @param mailUri the mail URL of the controller
     */
    @ConstructorBinding
    public PdfferMailerControllerProps(boolean enabled, String baseUri, String mailUri) {
        // set field values
        this.enabled = enabled;
        this.baseUri = baseUri;
        this.mailUri = mailUri;
    }

    // getters only

    /**
     * Indicates whether the mailer controller should be present.
     *
     * @return {@code true} if the mailer controller should be present
     */
    public boolean isEnabled() {
        return enabled;
    }

    /**
     * Gets the base URL of the controller.
     *
     * @return the base URL
     */
    public String getBaseUri() {
        return baseUri;
    }

    /**
     * Gets the URL for the mail endpoint of the controller.
     *
     * @return the mail URL
     */
    public String getMailUri() {
        return mailUri;
    }

}
