/*
 * Decompiled with CFR 0.152.
 */
package org.nekosoft.pdffer.registry;

import java.util.HashMap;
import java.util.Map;
import org.nekosoft.pdffer.registry.PdfferTemplateBeanNameGenerator;
import org.nekosoft.pdffer.registry.PdfferTemplateExcludeFilter;
import org.nekosoft.pdffer.registry.PdfferTemplateScopeMetadataResolver;
import org.nekosoft.pdffer.template.PdfTemplate;
import org.nekosoft.pdffer.template.PdfTemplateComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class PdfferTemplateComponentScanner
extends ClassPathBeanDefinitionScanner {
    private static final Logger logger = LoggerFactory.getLogger(PdfferTemplateComponentScanner.class);
    private final AnnotationConfigApplicationContext rootContext;
    private final Map<String, AnnotationConfigApplicationContext> templateRegistries;

    public PdfferTemplateComponentScanner() {
        this(new AnnotationConfigApplicationContext());
    }

    private PdfferTemplateComponentScanner(AnnotationConfigApplicationContext context) {
        super((BeanDefinitionRegistry)context, false);
        this.rootContext = context;
        this.rootContext.setId("pdffer-templates");
        this.rootContext.setAllowBeanDefinitionOverriding(false);
        this.templateRegistries = new HashMap<String, AnnotationConfigApplicationContext>();
        logger.debug("Creating ROOT template group {}", (Object)this.rootContext);
        this.templateRegistries.put("", this.rootContext);
        this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(PdfTemplateComponent.class));
        this.addExcludeFilter(new PdfferTemplateExcludeFilter());
        this.setBeanNameGenerator(new PdfferTemplateBeanNameGenerator());
        this.setScopeMetadataResolver(new PdfferTemplateScopeMetadataResolver());
    }

    protected boolean checkCandidate(String beanName, BeanDefinition beanDefinition) throws IllegalStateException {
        return true;
    }

    protected void registerBeanDefinition(BeanDefinitionHolder definitionHolder, BeanDefinitionRegistry registry) {
        try {
            Class<?> cls = Class.forName(definitionHolder.getBeanDefinition().getBeanClassName());
            PdfTemplateComponent annotation = cls.getAnnotation(PdfTemplateComponent.class);
            String templateGroup = annotation.group().trim();
            AnnotationConfigApplicationContext subcontext = this.templateRegistries.get(templateGroup);
            if (subcontext == null) {
                subcontext = new AnnotationConfigApplicationContext();
                subcontext.setId(templateGroup);
                subcontext.setParent((ApplicationContext)this.rootContext);
                subcontext.setAllowBeanDefinitionOverriding(false);
                logger.debug("Creating new template group {}", (Object)templateGroup);
                this.templateRegistries.put(templateGroup, subcontext);
            }
            logger.debug("Registering new template {}", (Object)PdfTemplate.getTemplatePath((String)templateGroup, (String)definitionHolder.getBeanName()));
            super.registerBeanDefinition(definitionHolder, (BeanDefinitionRegistry)subcontext);
        }
        catch (ClassNotFoundException e) {
            throw new BeanCreationException(definitionHolder.getBeanDefinition().getBeanClassName(), "Cannot find bean class");
        }
    }

    Map<String, AnnotationConfigApplicationContext> getTemplateRegistries() {
        return this.templateRegistries;
    }

    AnnotationConfigApplicationContext getTemplateRegistry(String group) {
        return this.templateRegistries.get(group);
    }

    AnnotationConfigApplicationContext getRootRegistry() {
        return this.getTemplateRegistry("");
    }
}

