/*
 * Decompiled with CFR 0.152.
 */
package org.nekosoft.pdffer.props;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import org.nekosoft.pdffer.props.EmailAddressInfo;
import org.nekosoft.pdffer.props.SmtpServerInfo;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.ConstructorBinding;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="pdffer.mailer")
@Validated
@ConditionalOnProperty(name={"pdffer.mailer.enabled"}, havingValue="true", matchIfMissing=false)
public class PdfferMailerProps {
    private final boolean enabled;
    private final EmailAddressInfo sendFrom;
    private final EmailAddressInfo replyTo;
    private final SmtpServerInfo smtp;

    @ConstructorBinding
    public PdfferMailerProps(boolean enabled, EmailAddressInfo sendFrom, EmailAddressInfo replyTo, SmtpServerInfo smtp) {
        this.enabled = enabled;
        this.sendFrom = sendFrom;
        this.replyTo = replyTo;
        this.smtp = smtp;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Valid
    public EmailAddressInfo getSendFrom() {
        return this.sendFrom;
    }

    @Valid
    public EmailAddressInfo getReplyTo() {
        return this.replyTo;
    }

    @NotNull(message="You must provide SMTP server information in order to use the PDFfer Mailer")
    @Valid
    public @NotNull(message="You must provide SMTP server information in order to use the PDFfer Mailer") @Valid SmtpServerInfo getSmtp() {
        return this.smtp;
    }
}

