/*
 * Decompiled with CFR 0.152.
 */
package org.nekosoft.pdffer.mail;

import java.util.Map;
import java.util.Properties;
import org.nekosoft.pdffer.props.PdfferMailerProps;
import org.nekosoft.pdffer.props.SmtpServerInfo;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

@Configuration
@ConditionalOnClass(name={"org.springframework.mail.javamail.JavaMailSender"})
@ConditionalOnProperty(name={"pdffer.mailer.enabled"}, havingValue="true", matchIfMissing=false)
public class PdfferMailerConfiguration {
    @Bean
    public JavaMailSender mailSender(PdfferMailerProps javaMailprops) {
        SmtpServerInfo smtpInfo = javaMailprops.getSmtp();
        JavaMailSenderImpl mailSender = new JavaMailSenderImpl();
        mailSender.setHost(smtpInfo.getHost());
        mailSender.setPort(smtpInfo.getPort());
        mailSender.setUsername(smtpInfo.getUsername());
        mailSender.setPassword(smtpInfo.getPassword());
        Properties props = mailSender.getJavaMailProperties();
        if (smtpInfo.getJavaMailProperties() != null) {
            props.putAll((Map<?, ?>)smtpInfo.getJavaMailProperties());
        }
        return mailSender;
    }
}

