/*
 * Decompiled with CFR 0.152.
 */
package org.nekosoft.pdffer.mail;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.nekosoft.pdffer.exception.MailAddressException;
import org.nekosoft.pdffer.exception.MailMessageException;
import org.nekosoft.pdffer.exception.MailSenderException;
import org.nekosoft.pdffer.props.PdfferMailerProps;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass(name={"org.springframework.mail.javamail.JavaMailSenderImpl"})
@ConditionalOnProperty(name={"pdffer.mailer.enabled"}, havingValue="true", matchIfMissing=false)
public class PdfferMailerBean {
    private final JavaMailSender mailSender;
    private PdfferMailerProps props;

    public PdfferMailerBean(JavaMailSender mailSender, PdfferMailerProps props) {
        this.mailSender = mailSender;
        this.props = props;
    }

    public void sendMessageWithPdfAttachment(String toString, String subject, String text, byte[] attachment, String filename, String sendFrom, String replyTo) throws MailAddressException, MailMessageException, MailSenderException {
        this.sendMessageWithPdfAttachmentToList(Arrays.asList(toString.split(",")), subject, text, attachment, filename, sendFrom, replyTo);
    }

    public void sendMessageWithPdfAttachmentToList(List<String> toList, String subject, String text, byte[] attachment, String filename, String sendFrom, String replyTo) throws MailAddressException, MailMessageException, MailSenderException {
        try {
            ArrayList<InternetAddress> recipients = new ArrayList<InternetAddress>();
            for (String email : toList) {
                recipients.add(new InternetAddress(email.trim()));
            }
            this.sendMessageWithPdfAttachment(recipients, subject, text, attachment, filename, sendFrom, replyTo);
        }
        catch (AddressException e) {
            throw new MailAddressException(e);
        }
    }

    public void sendMessageWithPdfAttachment(List<InternetAddress> to, String subject, String text, byte[] attachment, String filename, String sendFrom, String replyTo) throws MailAddressException, MailMessageException, MailSenderException {
        MimeMessage message = this.mailSender.createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            if (sendFrom != null) {
                helper.setFrom(sendFrom);
            } else {
                helper.setFrom(String.format("\"%s\" <%s>", this.props.getSendFrom().getName(), this.props.getSendFrom().getAddress()));
            }
            if (replyTo != null) {
                helper.setReplyTo(replyTo);
            } else {
                helper.setReplyTo(String.format("\"%s\" <%s>", this.props.getReplyTo().getName(), this.props.getReplyTo().getAddress()));
            }
            helper.setTo(to.toArray(new InternetAddress[0]));
            helper.setSubject(subject);
            helper.setText(text);
            helper.addAttachment(filename, (InputStreamSource)new ByteArrayResource(attachment), "application/pdf");
        }
        catch (AddressException e) {
            throw new MailAddressException(e);
        }
        catch (MessagingException e) {
            throw new MailMessageException(e);
        }
        try {
            this.mailSender.send(message);
        }
        catch (MailException e) {
            throw new MailSenderException(e);
        }
    }
}

