package org.nekosoft.pdffer;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigurationPackage;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

/**
 * The main Spring configuration class for PDFfer Core. It scans for Spring beans from the current package down,
 * and also reads all Properties POJOs from the {@link org.nekosoft.pdffer.props} package.
 */
@AutoConfiguration
@AutoConfigurationPackage
@ComponentScan
@ConfigurationPropertiesScan(basePackages = "org.nekosoft.pdffer.props")
public class PdfferCoreConfiguration {
    /**
     * The name of the profile that includes the Spring Actuator beans for PDFfer.
     */
    public static final String PROFILE_ACTUATOR = "pdffer-actuator";
    /**
     * The name of the profile that includes the Spring Shell beans for PDFfer.
     */
    public static final String PROFILE_SHELL = "pdffer-shell";
    /**
     * The name of the profile that includes the PDFfer Explorer website.
     */
    public static final String PROFILE_EXPLORER = "pdffer-explorer";

    @Bean
    LocalValidatorFactoryBean getValidator() {
        return new LocalValidatorFactoryBean();
    }

}
