/*
 * Decompiled with CFR 0.152.
 */
package org.nekosoft.pdffer.web;

import javax.servlet.http.HttpServletResponse;
import org.nekosoft.pdffer.PdfferProducerBean;
import org.nekosoft.pdffer.exception.MailAddressException;
import org.nekosoft.pdffer.exception.MailSenderException;
import org.nekosoft.pdffer.mail.PdfferMailerBean;
import org.nekosoft.pdffer.web.EmailRequestData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnWebApplication
@ConditionalOnClass(name={"javax.mail.internet.InternetAddress"})
@ConditionalOnBean(type={"org.nekosoft.pdffer.mail.PdfferMailerBean", "org.nekosoft.pdffer.PdfferProducerBean"})
@ConditionalOnProperty(name={"pdffer.mailer.controller.enable"}, havingValue="true", matchIfMissing=false)
@RequestMapping(value={"${pdffer.mailer.controller.base_uri:${pdffer.web.controller.base_uri:pdffer}}"})
public class PdfferMailerController {
    private static Logger logger = LoggerFactory.getLogger(PdfferMailerController.class);
    private final PdfferMailerBean pdfferMailer;
    private final PdfferProducerBean pdfferProducer;

    public PdfferMailerController(PdfferProducerBean pdfferProducer, PdfferMailerBean pdfferMailer) {
        this.pdfferProducer = pdfferProducer;
        this.pdfferMailer = pdfferMailer;
    }

    @PostMapping(value={"${pdffer.web.controller.email_uri:mail}/{templateId}"})
    public void email(@PathVariable String templateId, @RequestBody EmailRequestData requestData, HttpServletResponse response) {
        try {
            byte[] pdfBytes = this.pdfferProducer.generatePdfDocument(templateId, requestData.getPayload());
            this.pdfferMailer.sendMessageWithPdfAttachmentToList(requestData.getEmailTo(), requestData.getSubject(), requestData.getMessage(), pdfBytes, requestData.getFilename(), requestData.getSendFrom(), requestData.getReplyTo());
        }
        catch (MailAddressException e) {
            logger.debug("Bad Request", e.getCause());
            response.setStatus(400);
        }
        catch (MailSenderException e) {
            logger.error("Internal Server Error", e.getCause());
            response.setStatus(500);
        }
    }
}

