/*
 * Decompiled with CFR 0.152.
 */
package org.nekosoft.pdffer.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.nekosoft.pdffer.exception.TemplateGroupNotFoundException;
import org.nekosoft.pdffer.exception.TemplateNotFoundException;
import org.nekosoft.pdffer.registry.PdfferTemplateComponentScanner;
import org.nekosoft.pdffer.template.PdfTemplate;
import org.nekosoft.pdffer.template.PdfTemplateComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class PdfferRegistryBean {
    private static final Logger logger = LoggerFactory.getLogger(PdfferRegistryBean.class);
    private final Map<String, AnnotationConfigApplicationContext> templateRegistries;

    public PdfferRegistryBean() {
        this("org.nekosoft.PDFferTemplates");
    }

    PdfferRegistryBean(String basePackage) {
        logger.trace("Creating template registry application context");
        PdfferTemplateComponentScanner scanner = new PdfferTemplateComponentScanner();
        scanner.scan(new String[]{basePackage});
        this.templateRegistries = scanner.getTemplateRegistries();
        for (AnnotationConfigApplicationContext context : this.templateRegistries.values()) {
            context.refresh();
            context.start();
        }
        if (logger.isDebugEnabled()) {
            for (String templateName : this.listTemplatePaths()) {
                logger.debug("Added PDF template [{}]", (Object)templateName);
            }
        }
        logger.trace("Created separate template context [{}]", (Object)scanner.getRootRegistry());
    }

    public PdfTemplate<?> findTemplateByPath(String templatePath) throws TemplateNotFoundException {
        logger.trace("Looking for template path [{}]", (Object)templatePath);
        String[] groupName = PdfTemplate.splitTemplatePath((String)templatePath);
        return this.findTemplate(groupName[0], groupName[1]);
    }

    public PdfTemplate<?> findTemplate(String templateName) throws TemplateNotFoundException {
        logger.trace("Looking for template name [{}] in ROOT_REGISTRY", (Object)templateName);
        return this.findTemplate("", templateName);
    }

    public PdfTemplate<?> findTemplate(String group, String templateName) throws TemplateNotFoundException {
        logger.debug("Looking for template name [{}] in group [{}]", (Object)templateName, (Object)group);
        AnnotationConfigApplicationContext context = this.templateRegistries.get(group.trim());
        if (context == null) {
            throw new TemplateGroupNotFoundException(group);
        }
        try {
            return (PdfTemplate)context.getBean(templateName.trim(), PdfTemplate.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new TemplateNotFoundException(group, templateName);
        }
    }

    public List<String> listTemplatePaths() {
        AnnotationConfigApplicationContext context = this.templateRegistries.get("");
        ArrayList<String> names = new ArrayList<String>(List.of(context.getBeanNamesForAnnotation(PdfTemplateComponent.class)));
        for (Map.Entry<String, AnnotationConfigApplicationContext> subcontextEntry : this.templateRegistries.entrySet()) {
            if ("".equals(subcontextEntry.getKey())) continue;
            names.addAll(Stream.of(subcontextEntry.getValue().getBeanNamesForAnnotation(PdfTemplateComponent.class)).map(s -> PdfTemplate.getTemplatePath((String)((String)subcontextEntry.getKey()), (String)s)).sorted().collect(Collectors.toList()));
        }
        return names;
    }

    public List<String> listGroupNames() {
        return this.templateRegistries.keySet().stream().map(name -> "".equals(name) ? "\u001d/\u001d" : name).sorted().collect(Collectors.toList());
    }

    public List<String> listTemplateNamesInRoot() {
        return this.listTemplateNamesInGroup("");
    }

    public List<String> listTemplateNamesInGroup(String group) {
        ArrayList<String> names = new ArrayList<String>(List.of(this.templateRegistries.get(group).getBeanNamesForAnnotation(PdfTemplateComponent.class)));
        Collections.sort(names);
        return names;
    }

    Map<String, AnnotationConfigApplicationContext> getTemplateRegistries() {
        return this.templateRegistries;
    }
}

