/*
 * Decompiled with CFR 0.152.
 */
package org.nekosoft.pdffer.actuator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nekosoft.pdffer.registry.PdfferRegistryBean;
import org.nekosoft.pdffer.template.PdfTemplate;
import org.nekosoft.pdffer.template.PdfTemplateComponent;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Endpoint(id="pdffer-template-registry")
@ConditionalOnClass(name={"org.springframework.boot.actuate.endpoint.annotation.Endpoint"})
@Profile(value={"pddfer-actuator"})
public class TemplateRegistryEndpoint {
    private final PdfferRegistryBean registry;

    public TemplateRegistryEndpoint(PdfferRegistryBean registry) {
        this.registry = registry;
    }

    @ReadOperation
    public List<String> allTemplates() {
        return this.registry.listTemplatePaths();
    }

    @ReadOperation
    public Map<String, Object> template(@Selector String path) {
        PdfTemplate<?> template = this.registry.findTemplateByPath(path);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("Class Name", template.getClass().getName());
        data.put("Template Path", path);
        PdfTemplateComponent templateAnnotation = template.getClass().getAnnotation(PdfTemplateComponent.class);
        data.put("Template Group", templateAnnotation.group());
        data.put("Template Name", templateAnnotation.name());
        data.put("Template Scope", templateAnnotation.scope());
        return data;
    }
}

