/*
 * Decompiled with CFR 0.152.
 */
package org.nekosoft.pdffer.actuator;

import java.util.ArrayList;
import org.nekosoft.pdffer.PdfferProducerBean;
import org.nekosoft.pdffer.mail.PdfferMailerBean;
import org.nekosoft.pdffer.registry.PdfferRegistryBean;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass(name={"org.springframework.boot.actuate.health.HealthIndicator"})
@Profile(value={"pddfer-actuator"})
public class PdfferHealthIndicator
implements HealthIndicator {
    private ApplicationContext context;

    public PdfferHealthIndicator(ApplicationContext context) {
        this.context = context;
    }

    public Health health() {
        ArrayList<String> missing = new ArrayList<String>();
        ArrayList<String> tooMany = new ArrayList<String>();
        String[] producer = this.context.getBeanNamesForType(PdfferProducerBean.class);
        if (producer.length == 0) {
            missing.add("producer");
        } else if (producer.length > 1) {
            tooMany.add("producer");
        }
        String[] registry = this.context.getBeanNamesForType(PdfferRegistryBean.class);
        if (registry.length == 0) {
            missing.add("registry");
        } else if (registry.length > 1) {
            tooMany.add("registry");
        }
        String[] mailer = this.context.getBeanNamesForType(PdfferMailerBean.class);
        if (mailer.length == 0) {
            missing.add("mailer");
        } else if (mailer.length > 1) {
            tooMany.add("mailer");
        }
        if (missing.size() == 0 && tooMany.size() == 0) {
            return Health.up().withDetail("producer", (Object)producer[0]).withDetail("registry", (Object)registry[0]).withDetail("mailer", (Object)mailer[0]).build();
        }
        Health.Builder healthBuilder = missing.size() > 0 ? Health.down() : Health.unknown();
        return healthBuilder.withDetail("producer", (Object)(missing.contains("producer") ? "<none>" : "<many>")).withDetail("registry", (Object)(missing.contains("registry") ? "<none>" : "<many>")).withDetail("mailer", (Object)(missing.contains("mailer") ? "<none>" : "<many>")).build();
    }
}

