/*
 * Decompiled with CFR 0.152.
 */
package org.nekosoft.pdffer;

import java.lang.reflect.Method;
import java.util.Map;
import org.nekosoft.pdffer.exception.InvalidPayloadClassException;
import org.nekosoft.pdffer.exception.InvalidPayloadException;
import org.nekosoft.pdffer.exception.InvalidTemplateClassException;
import org.nekosoft.pdffer.exception.PdfferProducerException;
import org.nekosoft.pdffer.registry.PdfferRegistryBean;
import org.nekosoft.pdffer.template.AbstractJacksonPdfTemplate;
import org.nekosoft.pdffer.template.PdfTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PdfferProducerBean {
    private static Method plainPlayloadSetter;
    private static Method jsonPlayloadSetter;
    private static Method mapPlayloadSetter;
    private static final Logger logger;
    private final PdfferRegistryBean registry;

    public PdfferProducerBean(PdfferRegistryBean registry) {
        this.registry = registry;
    }

    public byte[] generatePdfDocumentByPath(String templatePath, Object data) {
        String[] split = PdfTemplate.splitTemplatePath((String)templatePath);
        return this.generatePdfDocument(split[0], split[1], data);
    }

    public byte[] generatePdfDocument(String templateName, Object data) {
        return this.generatePdfDocument("", templateName, data);
    }

    public <T> byte[] generatePdfDocument(String group, String templateName, T data) {
        return this.innerGeneratePdfDocument(group, templateName, PdfTemplate.class, plainPlayloadSetter, data);
    }

    public byte[] generatePdfDocumentByPathFromJsonString(String templatePath, String data) {
        String[] split = PdfTemplate.splitTemplatePath((String)templatePath);
        return this.generatePdfDocumentFromJsonString(split[0], split[1], data);
    }

    public byte[] generatePdfDocumentFromJsonString(String templateName, String data) {
        return this.generatePdfDocumentFromJsonString("", templateName, data);
    }

    public byte[] generatePdfDocumentFromJsonString(String group, String templateName, String data) {
        return this.innerGeneratePdfDocument(group, templateName, AbstractJacksonPdfTemplate.class, jsonPlayloadSetter, data);
    }

    public byte[] generatePdfDocumentByPathFromJsonMap(String templatePath, Map<String, Object> data) {
        String[] split = PdfTemplate.splitTemplatePath((String)templatePath);
        return this.generatePdfDocumentFromJsonMap(split[0], split[1], data);
    }

    public byte[] generatePdfDocumentFromJsonMap(String templateName, Map<String, Object> data) {
        return this.generatePdfDocumentFromJsonMap("", templateName, data);
    }

    public byte[] generatePdfDocumentFromJsonMap(String group, String templateName, Map<String, Object> data) {
        return this.innerGeneratePdfDocument(group, templateName, AbstractJacksonPdfTemplate.class, mapPlayloadSetter, data);
    }

    private PdfTemplate<?> findTemplate(String group, String template) {
        return this.registry.findTemplate(group, template);
    }

    private byte[] innerGeneratePdfDocument(String group, String templateName, Class<? extends PdfTemplate> expectedTemplateClass, Method payloadSetter, Object payload) {
        Class<?> actualPayloadClass;
        PdfTemplate<?> template = this.findTemplate(group, templateName);
        Class<?> actualTemplateClass = template.getClass();
        if (!expectedTemplateClass.isAssignableFrom(actualTemplateClass)) {
            logger.error("Class {} is not a valid template for {}", actualTemplateClass, expectedTemplateClass);
            throw new InvalidTemplateClassException(actualTemplateClass, expectedTemplateClass);
        }
        Class expectedPayloadClass = template.getPayloadClass();
        if (!expectedPayloadClass.isAssignableFrom(actualPayloadClass = payload.getClass())) {
            logger.error("Payload class {} is not a valid payload for {}", actualPayloadClass, (Object)expectedPayloadClass);
            throw new InvalidPayloadClassException(actualPayloadClass, expectedPayloadClass);
        }
        try {
            payloadSetter.invoke(template, payload);
        }
        catch (ReflectiveOperationException e) {
            logger.error("FATAL CONDITION IN PRODUCER INVOCATION", (Throwable)e);
            throw new PdfferProducerException(e);
        }
        if (!template.validate()) {
            throw new InvalidPayloadException(payload);
        }
        template.generate();
        return template.getPdfContent();
    }

    static {
        logger = LoggerFactory.getLogger(PdfferProducerBean.class);
        try {
            plainPlayloadSetter = PdfTemplate.class.getMethod("setPayload", Object.class);
            jsonPlayloadSetter = AbstractJacksonPdfTemplate.class.getMethod("setPayloadJson", String.class);
            mapPlayloadSetter = AbstractJacksonPdfTemplate.class.getMethod("setPayloadMap", Map.class);
        }
        catch (NoSuchMethodException e) {
            logger.error("FATAL CONDITION IN PRODUCER CREATION", (Throwable)e);
            throw new PdfferProducerException(e);
        }
    }
}

