package org.nekosoft.pdffer.registry;

import org.nekosoft.pdffer.template.PdfTemplateComponent;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ScopeMetadata;
import org.springframework.context.annotation.ScopeMetadataResolver;

/**
 * Determines the scope of a PDF template bean on the basis of the
 * {@link PdfTemplateComponent#singleton()} singleton} attribute of the  {@link PdfTemplateComponent} annotation.
 * <p>
 * if the attribute is {@code true} the template will be a singleton, otherwise it will be a prototype. The default is
 * prototype.
 */
public class PdfferTemplateScopeMetadataResolver implements ScopeMetadataResolver {
	@Override
	public ScopeMetadata resolveScopeMetadata(BeanDefinition definition) {
		try {
			Class<?> c = Class.forName(definition.getBeanClassName());
			PdfTemplateComponent annotation = c.getAnnotation(PdfTemplateComponent.class);
			ScopeMetadata scope = new ScopeMetadata();
			if (annotation.singleton()) {
				scope.setScopeName(BeanDefinition.SCOPE_SINGLETON);
			} else {
				scope.setScopeName(BeanDefinition.SCOPE_PROTOTYPE);
			}
			return scope;
		} catch (ClassNotFoundException e) { // this should never happen
			throw new BeanCreationException("Cannot find bean class");
		}
	}
}