package org.nekosoft.pdffer.registry;

import org.nekosoft.pdffer.template.PdfTemplateComponent;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;

/**
 * This configuration scans the {@link org.nekosoft.PDFferTemplates} package for templates.
 * The scanner is configured with a custom filter, name generator and scope resolver, and does not use
 * the default filters. In order to be picked up, classes need to implement the {@link org.nekosoft.pdffer.template.PdfTemplate}
 * interface and be annotated with {@link PdfTemplateComponent}.
 * <p>
 * Also see {@link PdfferTemplateBeanNameGenerator}, {@link PdfferTemplateScopeMetadataResolver}, {@link org.nekosoft.pdffer.registry.PdfferTemplateExcludeFilter}
 */
@Configuration
@ComponentScan(
		basePackages = "org.nekosoft.PDFferTemplates",
		useDefaultFilters = false,
		excludeFilters = @ComponentScan.Filter(
				type = FilterType.CUSTOM, value = PdfferTemplateExcludeFilter.class
		),
		includeFilters = @ComponentScan.Filter(
				type = FilterType.ANNOTATION, value = PdfTemplateComponent.class
		),
		nameGenerator = PdfferTemplateBeanNameGenerator.class,
		scopeResolver = PdfferTemplateScopeMetadataResolver.class
)
public class PdfferTemplateRegistryConfiguration {

}
