package org.nekosoft.pdffer.props;

import java.util.Properties;

/**
 * A nested Properties POJO class that stores the configuration of an SMTP server,
 * including a free Properties object for any extra configuration that is server-specific
 */
public class SmtpServerInfo {
    // field declarations
    private String host;
    private int port;
    private String username;
    private String password;
    private Properties javaMailProperties;

    /**
     * Creates a new SmtpServerInfo instance.
     *
     * @param host               the SMTP server hostname
     * @param port               the SMTP server port
     * @param username           the username
     * @param password           the password
     * @param javaMailProperties a free Properties object for any extra configuration that is server-specific
     */
    public SmtpServerInfo(String host, int port, String username, String password, Properties javaMailProperties) {
        // set field values
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.javaMailProperties = javaMailProperties;
    }

    // getters only

    /**
     * Gets the SMTP server hostname.
     *
     * @return the SMTP server hostname
     */
    public String getHost() {
        return host;
    }

    /**
     * the SMTP server port.
     *
     * @return the SMTP server port
     */
    public int getPort() {
        return port;
    }

    /**
     * Gets username.
     *
     * @return the username
     */
    public String getUsername() {
        return username;
    }

    /**
     * Gets password.
     *
     * @return the password
     */
    public String getPassword() {
        return password;
    }

    /**
     * Gets the free Properties object with server-specific extra configuration.
     *
     * @return Properties object with server-specific extra configuration
     */
    public Properties getJavaMailProperties() {
        return javaMailProperties;
    }
}
