package org.nekosoft.pdffer.props;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConstructorBinding;

/**
 * Provides the URL mappings for the endpoints defined by the PDFfer Web controller.
 */
@ConfigurationProperties(prefix = "pdffer.web.controller")
@ConstructorBinding
public class PdfferWebControllerProps {
    // field declarations
    /**
     * The base URL for the controller
     */
    String baseUri;
    /**
     * The URL for the Download endpoint of the controller
     */
    String downloadUri;

    /**
     * Creates a new PdfferMailerControllerProps instance with the given base and download URLs.
     *
     * @param baseUri base URL for the controller
     * @param downloadUri URL for the download endpoint
     */
    public PdfferWebControllerProps(String baseUri, String downloadUri) {
        // set field values
        this.baseUri = baseUri;
        this.downloadUri = downloadUri;
    }

    // getters and setters

    /**
     * Gets the base URL for the controller.
     *
     * @return the base URL for the controller
     */
    public String getBaseUri() {
        return baseUri;
    }

    /**
     * Gets the URL for the download endpoint.
     *
     * @return the URL for the download endpoint
     */
    public String getDownloadUri() {
        return downloadUri;
    }

}
