package org.nekosoft.pdffer.props;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConstructorBinding;

/**
 * The configuration for the PDFfer Mailer bean. It provides SMTP server configuration,
 * as well as default sender and reply to email data.
 */
@ConfigurationProperties(prefix = "pdffer.mailer")
@ConstructorBinding
public class PdfferMailerProps {
    // field declarations
    /** The default email address that will be used as the sender for the emails sent by PDFfer */
    private EmailAddressInfo sendFrom;
    /** The default email address that will be used as the reply-to header for the emails sent by PDFfer */
    private EmailAddressInfo replyTo;
    /** The settings of the SMTP server that will be used to send email messages from PDFfer */
    private SmtpServerInfo smtp;

    /**
     * Instantiates a new Pdffer mailer props.
     *
     * @param sendFrom the default send-from email address
     * @param replyTo  the default reply-to email address
     * @param smtp     the SMTP server info
     */
    public PdfferMailerProps(EmailAddressInfo sendFrom, EmailAddressInfo replyTo, SmtpServerInfo smtp) {
        // set field values
        this.sendFrom = sendFrom;
        this.replyTo = replyTo;
        this.smtp = smtp;
    }

    // getters only

    /**
     * Gets the default send-from email address.
     *
     * @return the default send-from email address
     */
    public EmailAddressInfo getSendFrom() {
        return sendFrom;
    }

    /**
     * Gets the default reply-to email address.
     *
     * @return the default reply-to email address
     */
    public EmailAddressInfo getReplyTo() {
        return replyTo;
    }

    /**
     * Gets the SMTP server info.
     *
     * @return the SMTP server info
     */
    public SmtpServerInfo getSmtp() {
        return smtp;
    }

}
