package org.nekosoft.pdffer.props;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConstructorBinding;

/**
 * Provides the URL mappings for the endpoints defined by the Mailer controller.
 */
@ConfigurationProperties(prefix = "pdffer.mailer.controller")
@ConstructorBinding
public class PdfferMailerControllerProps {

    // field declarations

    /**
     * The base URL for the controller.
     */
    String baseUri;
    /**
     * The URL for mail endpoint. This follows the base URL.
     */
    String mailUri;

    /**
     * Creates a new PdfferMailerControllerProps instance with the given base and mail URLs.
     *
     * @param baseUri base URL for the controller
     * @param mailUri URL for mail endpoint
     */
    public PdfferMailerControllerProps(String baseUri, String mailUri) {
        // set field values
        this.baseUri = baseUri;
        this.mailUri = mailUri;
    }

    // getters only

    /**
     * Gets the base URL for the controller.
     *
     * @return base URL for the controller
     */
    public String getBaseUri() {
        return baseUri;
    }

    /**
     * Gets the URL for mail endpoint.
     *
     * @return the URL for mail endpoint
     */
    public String getMailUri() {
        return mailUri;
    }

}
