package org.nekosoft.pdffer.props;

/**
 * A nested Properties POJO class that stores the `name` and `address` parts of
 * email address configuration
 */
public class EmailAddressInfo {
    // field declarations
    private String name;
    private String address;

    /**
     * Creates a new EmailAddressInfo instance.
     *
     * @param name    the name associated to the email address
     * @param address the email address
     */
    public EmailAddressInfo(String name, String address) {
        // set field values
        this.name = name;
        this.address = address;
    }

    // getters only

    /**
     * Gets the name associated to the email address.
     *
     * @return the name associated to the email address
     */
    public String getName() {
        return name;
    }

    /**
     * Gets the email address.
     *
     * @return the email address
     */
    public String getAddress() {
        return address;
    }
}
