package org.nekosoft.pdffer.mail;

import java.util.Properties;

import org.nekosoft.pdffer.props.PdfferMailerProps;
import org.nekosoft.pdffer.props.SmtpServerInfo;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

/**
 * The PDFfer Spring configuration for sending emails with attached PDFs. It just defines the JavaMailSender bean
 * with the associated required properties, but it needed a separate configuration class so that it could be made
 * conditional on the {@code JavaMailSender} class.
 */
@Configuration
@ConditionalOnClass(name = "org.springframework.mail.javamail.JavaMailSender")
@ConditionalOnProperty(name = "pdffer.skip.mailer.beans", havingValue = "false", matchIfMissing = true)
public class PdfferMailerConfiguration {

    /**
     * The {@code JavaMailSender} bean with the required configuration to send emails from the application.
     *
     * @param javaMailprops the {@link PdfferMailerProps} instance contained the Spring configuration properties
     *                     relating to email sending
     * @return the JavaMailSender bean
     */
    @Bean
    public JavaMailSender mailSender(PdfferMailerProps javaMailprops) {
        JavaMailSenderImpl mailSender = new JavaMailSenderImpl();

        SmtpServerInfo smtpInfo = javaMailprops.getSmtp();
        if ( smtpInfo != null) {
            mailSender.setHost(smtpInfo.getHost());
            mailSender.setPort(smtpInfo.getPort());
            mailSender.setUsername(smtpInfo.getUsername());
            mailSender.setPassword(smtpInfo.getPassword());
            mailSender.setUsername("your-usename");
            mailSender.setPassword("your-password");

            Properties props = smtpInfo.getJavaMailProperties();
            if (props != null) {
                mailSender.getJavaMailProperties().putAll(props);
            }
        }

        return mailSender;
    }

}
