/*
 * Decompiled with CFR 0.152.
 */
package org.nbnResolving.common;

import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nbnResolving.common.URNUtils;

public class UrlComparator
implements Comparator<String> {
    private static final Log LOGGER = LogFactory.getLog(UrlComparator.class);

    @Override
    public int compare(String url1, String url2) {
        if (url1 == null || url2 == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Can not compare NULL value!");
            }
            throw new ClassCastException("Can not compare NULL value!");
        }
        String correctedUrl = URNUtils.correctUrlString(url1, true, true);
        int result = correctedUrl.compareTo(URNUtils.correctUrlString(url2, true, true));
        if (LOGGER.isDebugEnabled()) {
            switch (result) {
                case 0: {
                    LOGGER.debug((Object)"URLs are equal.");
                    break;
                }
                case 1: {
                    LOGGER.debug((Object)(correctedUrl + " is greater"));
                    break;
                }
                default: {
                    LOGGER.debug((Object)(url2 + " is greater"));
                }
            }
        }
        return result;
    }
}

