/*
 * Decompiled with CFR 0.152.
 */
package org.nbnResolving.common;

import org.nbnResolving.common.Rfc3188Validator;
import org.nbnResolving.common.URNUtils;

public class DnbUrnValidator
extends Rfc3188Validator {
    public static final int MIN_URN_LENGTH = 16;
    public static final int MAX_URN_LENGTH = 254;
    public static final int MAX_NAMESPACE_LENGTH = 52;
    public static final int MAX_UNIQUE_PART_LENGTH = 201;
    public static final int URN_TOO_SHORT = 201;
    public static final int URN_TOO_LONG = 202;
    public static final int NO_SEPERATOR = 203;
    public static final int NAMESPACE_TOO_LONG = 204;
    public static final int UNIQUE_PART_TOO_LONG = 205;
    public static final int CHECKSUM_NOT_A_NUMBER = 210;
    public static final int INVALID_CHECKSUM = 211;
    public static final int UNKNOWN_NAMESPACE = 212;

    public static int validateUrn(String urn) {
        if (urn == null) {
            return 100;
        }
        int length = urn.length();
        if (length < 16) {
            return 201;
        }
        if (length > 254) {
            return 202;
        }
        int pos = urn.indexOf(45);
        if (pos < 1) {
            return 203;
        }
        if (pos > 52) {
            return 204;
        }
        if (length - pos > 201) {
            return 205;
        }
        int ret = Rfc3188Validator.validateUrn(urn);
        if (ret == 0) {
            String cs = urn.substring(urn.length() - 1);
            int checksumExisting = -1;
            try {
                checksumExisting = Integer.valueOf(cs);
                if (checksumExisting < 0 || checksumExisting > 9) {
                    return 210;
                }
            }
            catch (Exception e) {
                return 210;
            }
            String nbn = urn.substring(0, urn.length() - 1);
            int checksumExpected = URNUtils.getChecksum(nbn);
            if (checksumExisting != checksumExpected) {
                return 211;
            }
        }
        return ret;
    }
}

