/*
 * Decompiled with CFR 0.152.
 */
package org.nbnResolving.common;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.Date;
import java.util.Random;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class URNUtils {
    private static final Log LOGGER = LogFactory.getLog(URNUtils.class);
    private static final char[] chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '-', ':', '_', '/', '.', '+'};
    private static final String[] values = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "41", "18", "14", "19", "15", "16", "21", "22", "23", "24", "25", "42", "26", "27", "13", "28", "29", "31", "12", "32", "33", "11", "34", "35", "36", "37", "38", "39", "17", "43", "45", "47", "49"};
    private static final String ENCODING = "UTF-8";
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMddHHmmssSSS");

    public static int getChecksum(String tmpurn) {
        String urn = tmpurn.trim().toLowerCase();
        String cs = "";
        int i = 0;
        while (i < urn.length()) {
            boolean error = true;
            char c = urn.charAt(i);
            int j = 0;
            while (j < chars.length) {
                if (c == chars[j]) {
                    cs = String.valueOf(cs) + values[j];
                    error = false;
                }
                ++j;
            }
            if (error) {
                LOGGER.error((Object)"Invalid Character! Returning -1");
                return -1;
            }
            ++i;
        }
        int sum = 0;
        int i2 = 0;
        while (i2 < cs.length()) {
            String ss = cs.substring(i2, i2 + 1);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(String.valueOf(i2) + ". Substring = " + ss));
            }
            if (ss != null && !ss.equals("")) {
                Integer x = new Integer(ss);
                sum += x.byteValue() * (i2 + 1);
            } else {
                LOGGER.warn((Object)"getChecksum: Substring empty!");
            }
            ++i2;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("SUM = " + sum));
        }
        Integer last = new Integer(cs.substring(cs.length() - 1, cs.length()));
        sum = sum / last.byteValue() % 10;
        return sum;
    }

    public static String getURN(String tmpurn) {
        int checksum = URNUtils.getChecksum(tmpurn);
        if (checksum < 0) {
            return null;
        }
        return String.valueOf(tmpurn) + checksum;
    }

    public static String getURNforId(String ns, String id) {
        String urn = null;
        if (ns != null && ns.length() > 13) {
            urn = ns.endsWith("-") ? String.valueOf(ns) + id : String.valueOf(ns) + "-" + id;
            urn = URNUtils.getURN(String.valueOf(urn) + "-");
        }
        return urn;
    }

    public static String getRandomURN(String ns) {
        long ms = System.currentTimeMillis() % Integer.MAX_VALUE + 1000000000L;
        Random rnd = new Random();
        int rand = (int)(rnd.nextFloat() * 9000.0f) + 1000;
        int tid = (int)(Thread.currentThread().getId() % 90L) + 10;
        String id = Long.toString(ms);
        id = String.valueOf(id.substring(0, 5)) + "." + id.substring(5) + "." + rand + tid;
        return URNUtils.getURNforId(ns, id);
    }

    public static String getDateURN(String ns) {
        String id = dateFormatter.format(new Date());
        Random rnd = new Random();
        int rand = (int)(rnd.nextFloat() * 9000.0f) + 1000;
        int tid = (int)(Thread.currentThread().getId() % 900L) + 100;
        id = String.valueOf(id) + "-" + tid + rand;
        return URNUtils.getURNforId(ns, id);
    }

    public static String mapToString(AbstractMap<String, String> map, String delimiter) {
        if (map == null) {
            return null;
        }
        String ret = "";
        for (String key : map.keySet()) {
            if (key == null || key.isEmpty()) continue;
            ret = ret.isEmpty() ? String.valueOf(ret) + key : String.valueOf(ret) + delimiter + key;
            String value = map.get(key);
            if (value == null || value.isEmpty()) continue;
            ret = String.valueOf(ret) + "=" + value;
        }
        return ret;
    }

    public static String mapToEncodedString(AbstractMap<String, String> map, String delimiter) throws UnsupportedEncodingException {
        if (map == null) {
            return null;
        }
        String ret = "";
        for (String key : map.keySet()) {
            if (key == null || key.isEmpty()) continue;
            key = URNUtils.normalize(key, false);
            String value = map.get(key);
            ret = ret.isEmpty() ? String.valueOf(ret) + key : String.valueOf(ret) + delimiter + key;
            if (value == null || value.isEmpty()) continue;
            ret = String.valueOf(ret) + "=" + URNUtils.normalize(value, false);
        }
        return ret;
    }

    public static TreeMap<String, String> getParameterMap(String query, String regex) throws UnsupportedEncodingException {
        TreeMap<String, String> map = null;
        if (query != null && !query.isEmpty()) {
            map = new TreeMap<String, String>();
            String[] qa = query.split(regex);
            int i = 0;
            while (i < qa.length) {
                if (qa[i] != null && !qa[i].isEmpty()) {
                    String[] kva = qa[i].split("=");
                    String key = null;
                    String value = null;
                    if (kva.length > 0 && kva[0] != null && !kva[0].isEmpty()) {
                        key = URNUtils.normalize(kva[0], false);
                        if (kva.length > 1 && kva[1] != null && !kva[1].isEmpty()) {
                            value = URNUtils.normalize(kva[1], false);
                        }
                        map.put(key, value);
                    }
                }
                ++i;
            }
        }
        return map;
    }

    public static TreeMap<String, String> getParameterMap(URL url) throws UnsupportedEncodingException {
        if (url != null) {
            return URNUtils.getParameterMap(url.getQuery(), "[&;]");
        }
        return null;
    }

    public static AbstractMap<String, String> addMaps(AbstractMap<String, String> map1, AbstractMap<String, String> map2) throws UnsupportedEncodingException {
        if (map1 == null && map2 == null) {
            return null;
        }
        if (map1 == null) {
            return map2;
        }
        if (map1.isEmpty()) {
            return map2;
        }
        if (map2 == null) {
            return map1;
        }
        if (map2.isEmpty()) {
            return map1;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String key : map1.keySet()) {
            if (key == null || key.isEmpty()) continue;
            String value = map1.get(key);
            if (value != null && !value.isEmpty()) {
                value = URNUtils.normalize(value, false);
            }
            key = URNUtils.normalize(key, false);
            map.put(key, value);
        }
        for (String key : map2.keySet()) {
            String nk;
            if (key == null || key.isEmpty() || map.containsKey(nk = URNUtils.normalize(key, false))) continue;
            String value = map2.get(key);
            if (value != null && !value.isEmpty()) {
                value = URNUtils.normalize(value, false);
            }
            map.put(nk, value);
        }
        return map;
    }

    public static String getNormalisedPath(String path) throws UnsupportedEncodingException {
        String np = "";
        if (path != null && path.length() > 1) {
            String[] pa = path.split("/");
            int i = 0;
            while (i < pa.length) {
                if (pa[i] != null && !pa[i].isEmpty()) {
                    np = String.valueOf(np) + "/" + URNUtils.normalize(pa[i], false);
                }
                ++i;
            }
        }
        return np;
    }

    public static String correctUtf8error(String strToCorrect) throws UnsupportedEncodingException {
        String ucs;
        String str;
        String corrected = strToCorrect;
        String enc = "ISO-8859-1";
        byte[] ba = new byte[]{-62, -96};
        int[] cp = new int[]{160};
        while (cp[0] < 191) {
            ba[1] = (byte)(ba[1] + 1);
            cp[0] = cp[0] + 1;
            str = new String(ba, enc);
            ucs = new String(cp, 0, 1);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Calculated -> " + ba[0] + " " + ba[1] + "  str: " + str + " ucs: " + ucs));
            }
            corrected = corrected.replaceAll(str, ucs);
        }
        ba[0] = -61;
        ba[1] = 127;
        cp[0] = 191;
        while (cp[0] < 255) {
            ba[1] = (byte)(ba[1] + 1);
            cp[0] = cp[0] + 1;
            str = new String(ba, enc);
            ucs = new String(cp, 0, 1);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Calculated -> " + ba[0] + " " + ba[1] + "  str: " + str + " ucs: " + ucs));
            }
            corrected = corrected.replaceAll(str, ucs);
        }
        if (!corrected.equals(strToCorrect)) {
            LOGGER.info((Object)("\nInput String.: " + strToCorrect + "\nOutput String: " + corrected));
        }
        return corrected;
    }

    public static String correctUrlString(String urlStr, boolean correctEncoding, boolean checkJavaURI) {
        if (urlStr == null || urlStr.length() <= 3) {
            return null;
        }
        String ret = urlStr.trim().replaceAll("%25", "%");
        URL url = null;
        TreeMap<String, String> params = null;
        try {
            ret = URLDecoder.decode(ret, ENCODING);
            if (correctEncoding) {
                ret = URNUtils.correctUtf8error(ret);
            }
            url = new URL(ret);
            String host = url.getHost();
            String path = url.getPath();
            int port = url.getPort();
            String protocol = url.getProtocol();
            String anchor = url.getRef();
            String userInfo = url.getUserInfo();
            params = URNUtils.getParameterMap(url);
            ret = URNUtils.buildUrl(protocol, userInfo, host, port, path, params, false, anchor, checkJavaURI);
        }
        catch (Exception e) {
            LOGGER.error((Object)("ERROR! Exception. Original URL: " + urlStr + "\ncorrected URL: " + ret));
            e.printStackTrace();
            return null;
        }
        return ret;
    }

    public static String addQueryToUrl(String urlStr, String aq) throws MalformedURLException, UnsupportedEncodingException, URISyntaxException {
        if (urlStr == null) {
            return null;
        }
        if (urlStr.length() < 4) {
            return null;
        }
        if (aq == null) {
            return urlStr;
        }
        if (aq.length() < 1) {
            return urlStr;
        }
        String ret = urlStr.trim().replaceAll("%25", "%");
        ret = URLDecoder.decode(ret, ENCODING);
        String[] kva = aq.split("=");
        if (kva.length > 0 && kva[0] != null && !kva[0].isEmpty()) {
            String key = URNUtils.normalize(kva[0], false);
            URL url = new URL(ret);
            TreeMap<String, String> map = URNUtils.getParameterMap(url);
            if (map != null) {
                if (map.containsKey(key)) {
                    LOGGER.debug((Object)"addQueryToUrl(): key already exists --> returning the original URL");
                    return urlStr;
                }
            } else {
                map = new TreeMap();
            }
            String value = null;
            if (kva.length > 1 && kva[1] != null && !kva[1].isEmpty()) {
                value = URNUtils.normalize(kva[1], false);
            }
            map.put(key, value);
            ret = URNUtils.buildUrl(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), URNUtils.getNormalisedPath(url.getPath()), map, false, url.getRef(), true);
        }
        return ret;
    }

    public static String addParamsToUrl(String urlStr, AbstractMap<String, String> params) throws UnsupportedEncodingException, MalformedURLException, URISyntaxException {
        if (urlStr == null) {
            return null;
        }
        if (urlStr.length() < 4) {
            return null;
        }
        if (params == null) {
            return urlStr;
        }
        if (params.isEmpty()) {
            return urlStr;
        }
        String ret = urlStr.trim().replaceAll("%25", "%");
        ret = URLDecoder.decode(ret, ENCODING);
        URL url = new URL(ret);
        ret = URNUtils.buildUrl(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), URNUtils.getNormalisedPath(url.getPath()), URNUtils.addMaps(URNUtils.getParameterMap(url), params), false, url.getRef(), false);
        return ret;
    }

    public static String buildUrl(String protocol, String userInfo, String host, int port, String path, AbstractMap<String, String> params, boolean encodeParams, String anchor, boolean checkJavaURI) throws UnsupportedEncodingException, URISyntaxException, MalformedURLException {
        String norm = "";
        norm = protocol != null && protocol.length() > 1 ? String.valueOf(norm) + protocol.trim().toLowerCase() + "://" : String.valueOf(norm) + "http://";
        if (userInfo != null && userInfo.length() > 2) {
            norm = String.valueOf(norm) + userInfo.trim() + "@";
        }
        if (host == null || host.length() <= 3) {
            throw new MalformedURLException("No host Name!");
        }
        norm = String.valueOf(norm) + host.trim().toLowerCase();
        if (port > 0) {
            norm = String.valueOf(norm) + ":" + port;
        }
        norm = String.valueOf(norm) + URNUtils.getNormalisedPath(path);
        if (params != null && !params.isEmpty()) {
            norm = encodeParams ? String.valueOf(norm) + "?&" + URNUtils.mapToEncodedString(params, "&") : String.valueOf(norm) + "?&" + URNUtils.mapToString(params, "&");
        }
        if (anchor != null && !anchor.isEmpty()) {
            norm = String.valueOf(norm) + "#" + URNUtils.normalize(anchor, false);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Corrected URL:\n" + norm));
        }
        if (checkJavaURI) {
            URL url = new URL(norm);
            url.toURI();
            norm = url.toExternalForm();
        }
        return norm;
    }

    public static String normalize(String str, boolean lowerCase) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        String ret = str.trim();
        if (lowerCase) {
            ret = ret.toLowerCase();
        }
        ret = ret.replaceAll("%25", "%");
        ret = URLDecoder.decode(ret, ENCODING);
        ret = URLEncoder.encode(ret, ENCODING);
        ret = ret.replaceAll("%7E", "~");
        ret = ret.replaceAll("%2C", ",");
        return ret;
    }
}

