/*
 * Decompiled with CFR 0.152.
 */
package org.nbnResolving.common;

import java.util.Locale;

public class Rfc3188Validator {
    public static String[] iso3106Codes = Locale.getISOCountries();
    public static final char[] VALID_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '-', ':', '_', '.'};
    public static final int URN_IS_VALID = 0;
    public static final int URN_EQUALS_NULL = 100;
    public static final int URN_IS_EMPTY = 101;
    public static final int NID_TOO_SHORT = 102;
    public static final int PART_COUNT_TOO_LOW = 103;
    public static final int MUST_START_WITH_URN = 104;
    public static final int NOT_A_NBN = 105;
    public static final int NOT_TWO_DIGIT_CODE = 106;
    public static final int BAD_COUNTRY_CODE = 107;
    public static final int EMPTY_SUBNAMESPACE = 108;
    public static final int EMPTY_NBN_STRING = 109;
    public static final int INVALID_CHAR_NID = 110;
    public static final int INVALID_CHAR_NBN = 111;

    public static int validateUrn(String urn) {
        if (urn == null) {
            return 100;
        }
        if (urn.isEmpty()) {
            return 101;
        }
        String nbn = urn.trim();
        int seperator = nbn.indexOf("-");
        if (seperator < 10) {
            return 102;
        }
        String nid = nbn.substring(0, seperator).toUpperCase();
        String[] parts = nid.split(":");
        if (parts.length < 4) {
            return 103;
        }
        if (parts[0] == null || !parts[0].equals("URN")) {
            return 104;
        }
        if (parts[1] == null || !parts[1].equals("NBN")) {
            return 105;
        }
        if (parts[2] == null || parts[2].length() != 2) {
            return 106;
        }
        if (parts[3] == null || parts[3].isEmpty()) {
            return 108;
        }
        boolean valid = false;
        int i = 0;
        while (i < iso3106Codes.length) {
            if (parts[2].equals(iso3106Codes[i])) {
                valid = true;
                break;
            }
            ++i;
        }
        if (!valid) {
            return 107;
        }
        String nss = nbn.substring(seperator + 1);
        if (nss == null || nss.isEmpty()) {
            return 109;
        }
        int i2 = 3;
        while (i2 < parts.length) {
            if (!Rfc3188Validator.charsValid(parts[i2])) {
                return 110;
            }
            ++i2;
        }
        if (!Rfc3188Validator.charsValid(nss.toUpperCase())) {
            return 111;
        }
        return 0;
    }

    public static boolean charsValid(String str) {
        int i = 0;
        while (i < str.length()) {
            boolean error = true;
            char c = str.charAt(i);
            int j = 0;
            while (j < VALID_CHARS.length) {
                if (c == VALID_CHARS[j]) {
                    error = false;
                }
                ++j;
            }
            if (error) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

