/**********************************************************************
 * Class UrlComparator
 *  
 * Copyright (c) 2011-2012, German National Library/Deutsche Nationalbibliothek
 * Adickesallee 1, D-60322 Frankfurt am Main, Federal Republic of Germany
 *
 * This program is free software.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 * Kadir Karaca Kocer -- German National Library
 * 
 **********************************************************************/

/* ********************************************************************
 * CHANGELOG:
 * 2012-03-14 Commented and ported to Apache Maven
 *********************************************************************/

package org.nbnResolving.common;

import java.util.Comparator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author J. Kett
 *
 */
public class UrlComparator implements Comparator<String> {

    private static final Log LOGGER = LogFactory.getLog(UrlComparator.class);

	/**
	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	 */
	@Override
	public int compare(String url1, String url2) {
		int result = url1.compareTo(url2);
		if (result == 0) {
			LOGGER.info(url2);
		} 
		return result;
	}
}