/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.models.gitlab.util;

import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ThrottlingHandler
extends Handler {
    private static final Pattern REQUEST_PATTERN = Pattern.compile("\\d+ - Sending client request on thread .+");
    private static final Pattern RESPONSE_PATTERN = Pattern.compile("\\d+ - Received server response on thread .+");
    private static final Pattern RATE_LIMIT_PREFIX_PATTERN = Pattern.compile("^\\d+ < RateLimit-Limit: ");
    private static final Pattern RATE_LIMIT_REMAINING_PREFIX_PATTERN = Pattern.compile("^\\d+ < RateLimit-Remaining: ");
    private static final Pattern RATE_LIMIT_RESET_PREFIX_PATTERN = Pattern.compile("^\\d+ < RateLimit-Reset: ");
    private static final Pattern DATE_PREFIX_PATTERN = Pattern.compile("^\\d+ < Date: ");
    private int conservatism = 3;
    private int factor = 10;
    private long clientRateLimitWindow = -1L;
    private int clientRateLimit = -1;
    private AtomicLong clientRateLimitWindowEnd = new AtomicLong();
    private AtomicInteger clientRateLimitWindowRequestsRemaining = new AtomicInteger();
    private AtomicInteger serverRateLimit = new AtomicInteger();
    private AtomicInteger serverRateLimitRemaining = new AtomicInteger();
    private AtomicLong serverRateLimitReset = new AtomicLong();
    private AtomicLong serverResponseTime = new AtomicLong();

    public ThrottlingHandler() {
    }

    public ThrottlingHandler(long clientRateLimitWindow, int clientRateLimit) {
        this.clientRateLimitWindow = clientRateLimitWindow;
        this.clientRateLimit = clientRateLimit;
    }

    public int getConservatism() {
        return this.conservatism;
    }

    public void setConservatism(int conservatism) {
        this.conservatism = conservatism;
    }

    public int getFactor() {
        return this.factor;
    }

    public void setFactor(int factor) {
        this.factor = factor;
    }

    @Override
    public void publish(LogRecord logRecord) {
        String message = logRecord.getMessage();
        String[] lines = message.split("\\r?\\n");
        if (REQUEST_PATTERN.matcher(lines[0]).matches()) {
            long clientRateWindowDelta;
            long clientToSleep;
            long clientRateWindowDelta2;
            long now = System.currentTimeMillis();
            if (this.clientRateLimit > 0 && this.clientRateLimitWindow > 0L && (clientRateWindowDelta2 = now - this.clientRateLimitWindowEnd.get()) >= 0L) {
                this.clientRateLimitWindowEnd.set(now + this.clientRateLimitWindow);
                this.clientRateLimitWindowRequestsRemaining.set(this.clientRateLimit);
            }
            int rateLimit = this.serverRateLimit.get();
            int rateLimitRemaining = this.serverRateLimitRemaining.get();
            long rateLimitReset = this.serverRateLimitReset.get();
            long toSleep = -1L;
            if (rateLimit > 0 && rateLimitRemaining > 0 && rateLimitRemaining * this.factor < rateLimit) {
                long delta = rateLimitReset - this.serverResponseTime.get();
                toSleep = (delta += (long)this.conservatism) * 1000L / (long)rateLimitRemaining;
            }
            if (this.clientRateLimit > 0 && this.clientRateLimitWindow > 0L && (clientToSleep = (clientRateWindowDelta = this.clientRateLimitWindowEnd.get() - now) / (long)Math.max(this.clientRateLimitWindowRequestsRemaining.decrementAndGet(), 1)) > toSleep) {
                toSleep = clientToSleep;
            }
            if (toSleep > 0L) {
                try {
                    Thread.sleep(toSleep);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        if (RESPONSE_PATTERN.matcher(lines[0]).matches()) {
            int rateLimit = -1;
            int rateLimitRemaining = -1;
            long rateLimitReset = -1L;
            ChronoZonedDateTime date = null;
            for (String line : lines) {
                Matcher rateLimitMatcher = RATE_LIMIT_PREFIX_PATTERN.matcher(line);
                if (rateLimitMatcher.find()) {
                    rateLimit = Integer.parseInt(line.substring(rateLimitMatcher.end()));
                    continue;
                }
                Matcher rateLimitRemainingMatcher = RATE_LIMIT_REMAINING_PREFIX_PATTERN.matcher(line);
                if (rateLimitRemainingMatcher.find()) {
                    rateLimitRemaining = Integer.parseInt(line.substring(rateLimitRemainingMatcher.end()));
                    continue;
                }
                Matcher rateLimitResetMatcher = RATE_LIMIT_RESET_PREFIX_PATTERN.matcher(line);
                if (rateLimitResetMatcher.find()) {
                    rateLimitReset = Long.parseLong(line.substring(rateLimitResetMatcher.end()));
                    continue;
                }
                Matcher dateMatcher = DATE_PREFIX_PATTERN.matcher(line);
                if (!dateMatcher.find()) continue;
                String dateString = line.substring(dateMatcher.end());
                date = ZonedDateTime.parse(dateString, DateTimeFormatter.RFC_1123_DATE_TIME);
            }
            this.serverRateLimit.set(rateLimit);
            this.serverRateLimitRemaining.set(rateLimitRemaining);
            this.serverRateLimitReset.set(rateLimitReset);
            this.serverResponseTime.set(date == null ? System.currentTimeMillis() / 1000L : date.toEpochSecond());
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

