/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.models.gitlab.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GroupApi;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.ProjectApi;
import org.gitlab4j.api.RepositoryApi;
import org.gitlab4j.api.RepositoryFileApi;
import org.gitlab4j.api.models.Commit;
import org.gitlab4j.api.models.Group;
import org.gitlab4j.api.models.GroupFilter;
import org.gitlab4j.api.models.ImportStatus;
import org.gitlab4j.api.models.Permissions;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.models.gitlab.AbstractUser;
import org.nasdanika.models.gitlab.AccessLevel;
import org.nasdanika.models.gitlab.AutoDevopsDeployStrategy;
import org.nasdanika.models.gitlab.Blob;
import org.nasdanika.models.gitlab.Branch;
import org.nasdanika.models.gitlab.BuildGitStrategy;
import org.nasdanika.models.gitlab.Contributor;
import org.nasdanika.models.gitlab.GitLab;
import org.nasdanika.models.gitlab.GitLabFactory;
import org.nasdanika.models.gitlab.Group;
import org.nasdanika.models.gitlab.Member;
import org.nasdanika.models.gitlab.MergeMethod;
import org.nasdanika.models.gitlab.Owner;
import org.nasdanika.models.gitlab.Project;
import org.nasdanika.models.gitlab.ProjectAccess;
import org.nasdanika.models.gitlab.ProjectLicense;
import org.nasdanika.models.gitlab.ProjectSharedGroup;
import org.nasdanika.models.gitlab.ProjectStatistics;
import org.nasdanika.models.gitlab.RepositoryFile;
import org.nasdanika.models.gitlab.SquashOption;
import org.nasdanika.models.gitlab.Status;
import org.nasdanika.models.gitlab.Tree;
import org.nasdanika.models.gitlab.TreeItem;
import org.nasdanika.models.gitlab.Visibility;
import org.nasdanika.models.gitlab.util.ThrottlingHandler;

@Deprecated
public class LoaderOld
implements AutoCloseable {
    private static final String ROOT_PATH = "/";
    private GitLabApi gitLabApi;
    private GitLabFactory factory = GitLabFactory.eINSTANCE;
    private int groupsPageSize = 10;
    private Executor executor = r -> r.run();

    public int getGroupsPageSize() {
        return this.groupsPageSize;
    }

    public void setGroupsPageSize(int groupsPageSize) {
        this.groupsPageSize = groupsPageSize;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public GitLabApi getGitLabApi() {
        return this.gitLabApi;
    }

    public LoaderOld(String hostUrl, String accessToken) {
        this(new GitLabApi(hostUrl, accessToken));
    }

    public LoaderOld(GitLabApi gitLabApi) {
        this(gitLabApi, new ThrottlingHandler());
    }

    public LoaderOld(String hostUrl, String accessToken, long clientRateLimitWindow, int clientRateLimit) {
        this(new GitLabApi(hostUrl, accessToken), clientRateLimitWindow, clientRateLimit);
    }

    public LoaderOld(GitLabApi gitLabApi, long clientRateLimitWindow, int clientRateLimit) {
        this(gitLabApi, new ThrottlingHandler(clientRateLimitWindow, clientRateLimit));
    }

    public LoaderOld(GitLabApi gitLabApi, Handler throttlingHandler) {
        if (throttlingHandler != null) {
            Level level = Level.FINE;
            throttlingHandler.setLevel(level);
            Logger logger = Logger.getLogger(GitLabApi.class.getName());
            Level loggerLevel = logger.getLevel();
            if (loggerLevel == null || loggerLevel.intValue() > level.intValue()) {
                logger.setLevel(level);
            }
            logger.addHandler(throttlingHandler);
            gitLabApi.enableRequestResponseLogging();
        }
        this.gitLabApi = gitLabApi;
    }

    public GitLabFactory getFactory() {
        return this.factory;
    }

    public void setFactory(GitLabFactory factory) {
        this.factory = factory;
    }

    public GitLab loadGitLabGroups(ProgressMonitor progressMonitor) throws GitLabApiException {
        GitLab ret = this.getFactory().createGitLab();
        ret.getGroups().addAll(this.loadGroups(progressMonitor));
        return ret;
    }

    protected ProjectLicense loadProjectLicense(org.gitlab4j.api.ProjectLicense apiLicense, ProgressMonitor progressMonitor) {
        ProjectLicense modelLicense = this.getFactory().createProjectLicense();
        modelLicense.setHtmlUrl(apiLicense.getHtmlUrl());
        modelLicense.setKey(apiLicense.getKey());
        modelLicense.setName(apiLicense.getName());
        modelLicense.setNickname(apiLicense.getNickname());
        modelLicense.setSourceUrl(apiLicense.getSourceUrl());
        return modelLicense;
    }

    protected void populateAbstractUser(org.gitlab4j.api.models.AbstractUser<?> apiUser, AbstractUser user) {
        user.setAvatarUrl(apiUser.getAvatarUrl());
        user.setCreatedAt(apiUser.getCreatedAt());
        user.setEMail(apiUser.getEmail());
        user.setId(apiUser.getId());
        user.setName(apiUser.getName());
        user.setState(apiUser.getState());
        user.setUserName(apiUser.getUsername());
        user.setWebUrl(apiUser.getWebUrl());
    }

    protected GroupFilter getGroupFilter() {
        return new GroupFilter();
    }

    public List<Group> loadGroups(ProgressMonitor progressMonitor) throws GitLabApiException {
        long exceptionally;
        Map groupMap = Collections.synchronizedMap(new HashMap());
        Function<Long, CompletableFuture> groupProvider = id -> groupMap.computeIfAbsent(id, _id -> new CompletableFuture());
        Map projectMap = Collections.synchronizedMap(new HashMap());
        Function<Long, CompletableFuture> projectProvider = id -> projectMap.computeIfAbsent(id, _id -> new CompletableFuture());
        List<Group> rootGroups = Collections.synchronizedList(new ArrayList());
        List<Group> childGroups = Collections.synchronizedList(new ArrayList());
        Collection groupCompletableFutures = Collections.synchronizedCollection(new ArrayList());
        try (ProgressMonitor groupsMonitor = progressMonitor.split("Loading groups", 1.0, new Object[0]);){
            GroupApi groupApi = this.gitLabApi.getGroupApi();
            Pager groupPager = groupApi.getGroups(this.getGroupFilter(), this.getGroupsPageSize());
            int pageNum = 0;
            while (groupPager.hasNext()) {
                double monitorSize = 1.0 / Math.pow(2.0, ++pageNum);
                ProgressMonitor groupPageMonitor = groupsMonitor.split("Group page " + pageNum, monitorSize, new Object[0]);
                try {
                    List groups = groupPager.next();
                    ProgressMonitor scaledGroupsMonitor = groupPageMonitor.scale((double)(groups.size() + 1));
                    try {
                        scaledGroupsMonitor.worked(org.nasdanika.common.Status.INFO, 1.0, "Retrieved " + groups.size() + " groups", new Object[0]);
                        for (org.gitlab4j.api.models.Group group : groups) {
                            ProgressMonitor groupMonitor = scaledGroupsMonitor.split("Loading group " + group.getName() + " " + group.getId(), 1.0, new Object[]{group});
                            try {
                                CompletableFuture modelGroupCompletableFuture = new CompletableFuture();
                                groupCompletableFutures.add(modelGroupCompletableFuture);
                                this.executor.execute(() -> {
                                    Group modelGroup = this.loadGroup(group, groupApi, groupProvider, projectProvider, groupMonitor);
                                    modelGroupCompletableFuture.complete(Map.entry(group, modelGroup));
                                });
                            }
                            finally {
                                if (groupMonitor == null) continue;
                                groupMonitor.close();
                            }
                        }
                    }
                    finally {
                        if (scaledGroupsMonitor == null) continue;
                        scaledGroupsMonitor.close();
                    }
                }
                finally {
                    if (groupPageMonitor == null) continue;
                    groupPageMonitor.close();
                }
            }
        }
        for (CompletableFuture completableFuture : groupCompletableFutures) {
            Long parentId;
            Map.Entry groupEntry = (Map.Entry)completableFuture.join();
            org.gitlab4j.api.models.Group group = (org.gitlab4j.api.models.Group)groupEntry.getKey();
            Group modelGroup = (Group)groupEntry.getValue();
            if (!groupProvider.apply(group.getId()).complete(modelGroup)) {
                progressMonitor.worked(1.0, "Group completable future already completed for " + group.getId() + " " + group.getFullName(), new Object[]{group});
            }
            if ((parentId = group.getParentId()) == null) {
                rootGroups.add(modelGroup);
                continue;
            }
            groupProvider.apply(parentId).thenAccept(pg -> {
                EList<Group> subGroups = pg.getSubGroups();
                LoaderOld loaderOld = this;
                synchronized (loaderOld) {
                    subGroups.add((Object)modelGroup);
                }
            });
        }
        long incomplete = groupMap.values().stream().filter(cf -> !cf.isDone()).count();
        if (incomplete > 0L) {
            progressMonitor.worked(1.0, "There are incomplete set parent futures (orphan child groups): " + incomplete, new Object[0]);
            for (Group childGroup : childGroups) {
                rootGroups.add(childGroup);
            }
        }
        if ((exceptionally = groupMap.values().stream().filter(cf -> cf.isCompletedExceptionally()).count()) > 0L) {
            progressMonitor.worked(1.0, "There are exceptionally completed set parent futures: " + exceptionally, new Object[0]);
            for (CompletableFuture cf2 : groupMap.values()) {
                if (!cf2.isCompletedExceptionally()) continue;
                cf2.exceptionally(th -> {
                    progressMonitor.worked(1.0, "Exceptional completion: " + th, new Object[]{th});
                    return null;
                });
            }
        }
        return rootGroups;
    }

    protected Group createGroup(org.gitlab4j.api.models.Group group, GroupApi groupApi, Function<Long, CompletableFuture<Group>> groupProvider, Function<Long, CompletableFuture<Project>> projectProvider, ProgressMonitor progressMonitor) {
        return this.getFactory().createGroup();
    }

    protected Group loadGroup(org.gitlab4j.api.models.Group group, GroupApi groupApi, Function<Long, CompletableFuture<Group>> groupProvider, Function<Long, CompletableFuture<Project>> projectProvider, ProgressMonitor progressMonitor) {
        Group modelGroup = this.createGroup(group, groupApi, groupProvider, projectProvider, progressMonitor);
        modelGroup.setAvatarUrl(group.getAvatarUrl());
        modelGroup.setCreatedAt(group.getCreatedAt());
        modelGroup.setDescription(group.getDescription());
        modelGroup.setFullName(group.getFullName());
        modelGroup.setFullPath(group.getFullPath());
        modelGroup.setId(group.getId());
        Group.Statistics stats = group.getStatistics();
        if (stats != null) {
            modelGroup.setJobArtifactsSize(stats.getJobArtifactsSize());
            modelGroup.setLfsObjectsSize(stats.getLfsObjectsSize());
            modelGroup.setRepositorySize(stats.getRepositorySize());
            modelGroup.setStorageSize(stats.getStorageSize());
        }
        modelGroup.setLfsEnabled(group.getLfsEnabled());
        modelGroup.setName(group.getName());
        modelGroup.setPath(group.getPath());
        modelGroup.setVisibility(Visibility.get(group.getVisibility().ordinal()));
        modelGroup.setWebUrl(group.getWebUrl());
        EList<Project> modelGroupProjects = modelGroup.getProjects();
        try {
            List groupProjects = groupApi.getProjects((Object)group.getId());
            List groupMembers = groupApi.getMembers((Object)group.getId());
            try (ProgressMonitor scaledGroupMonitor = progressMonitor.scale((double)(1 + groupProjects.size() + groupMembers.size()));){
                scaledGroupMonitor.worked(org.nasdanika.common.Status.INFO, 1.0, "Retrieved " + groupProjects.size() + " projects and " + groupMembers.size() + " members", new Object[0]);
                for (org.gitlab4j.api.models.Project project : groupProjects) {
                    ProgressMonitor projectMonitor = scaledGroupMonitor.split("Loading project " + project.getName() + " " + project.getId(), 1.0, new Object[]{project});
                    try {
                        if (!Objects.equals(project.getNamespace().getId(), group.getId())) continue;
                        Project modelProject = this.loadProject(project, groupProvider, projectProvider, projectMonitor);
                        modelGroupProjects.add((Object)modelProject);
                    }
                    finally {
                        if (projectMonitor == null) continue;
                        projectMonitor.close();
                    }
                }
                EList<Member> modelGroupMembers = modelGroup.getMembers();
                for (org.gitlab4j.api.models.Member member : groupMembers) {
                    ProgressMonitor memberMonitor = scaledGroupMonitor.split("Loading member " + member.getName() + " " + member.getId(), 1.0, new Object[]{member});
                    try {
                        Member modelMember = this.loadMember(member, memberMonitor);
                        modelGroupMembers.add((Object)modelMember);
                    }
                    finally {
                        if (memberMonitor == null) continue;
                        memberMonitor.close();
                    }
                }
            }
        }
        catch (GitLabApiException e) {
            progressMonitor.worked(org.nasdanika.common.Status.ERROR, 1.0, "Failed to load group", new Object[]{group, e});
        }
        return modelGroup;
    }

    protected Project createProject(org.gitlab4j.api.models.Project project, Function<Long, CompletableFuture<Group>> groupProvider, Function<Long, CompletableFuture<Project>> projectProvider, ProgressMonitor progressMonitor) {
        return this.getFactory().createProject();
    }

    protected Owner createOwner(org.gitlab4j.api.models.Owner owner, ProgressMonitor progressMonitor) {
        return this.getFactory().createOwner();
    }

    protected Branch createBranch(org.gitlab4j.api.models.Branch branch, ProgressMonitor progressMonitor) {
        return this.getFactory().createBranch();
    }

    protected Contributor createContributor(org.gitlab4j.api.models.Contributor contributor, ProgressMonitor progressMonitor) {
        return this.getFactory().createContributor();
    }

    protected Project loadProject(org.gitlab4j.api.models.Project project, Function<Long, CompletableFuture<Group>> groupProvider, Function<Long, CompletableFuture<Project>> projectProvider, ProgressMonitor progressMonitor) {
        List apiCustomAttributes;
        Project modelProject = this.createProject(project, groupProvider, projectProvider, progressMonitor);
        modelProject.setId(project.getId());
        modelProject.setApprovalsBeforeMerge(project.getApprovalsBeforeMerge());
        modelProject.setArchived(project.getArchived());
        modelProject.setAvatarUrl(project.getAvatarUrl());
        modelProject.setContainerRegistryEnabled(project.getContainerRegistryEnabled());
        modelProject.setCreatedAt(project.getCreatedAt());
        modelProject.setCreatorId(project.getCreatorId());
        modelProject.setDefaultBranch(project.getDefaultBranch());
        modelProject.setDescription(project.getDescription());
        modelProject.setForksCount(project.getForksCount());
        org.gitlab4j.api.models.Project forkedFrom = project.getForkedFromProject();
        if (forkedFrom != null) {
            projectProvider.apply(forkedFrom.getId()).thenAccept(modelProject::setForkedFrom);
        }
        modelProject.setHttpUrlToRepo(project.getHttpUrlToRepo());
        modelProject.setIsPublic(project.getPublic());
        modelProject.setIssuesEnabled(project.getIssuesEnabled());
        modelProject.setJobsEnabled(project.getJobsEnabled());
        modelProject.setLastsActivityAt(project.getLastActivityAt());
        modelProject.setLfsEnabled(project.getLfsEnabled());
        modelProject.setMergeMethod(MergeMethod.get(project.getMergeMethod().ordinal()));
        modelProject.setMergeRequestsEnabled(project.getMergeRequestsEnabled());
        modelProject.setName(project.getName());
        modelProject.setNameWithNamespace(project.getNameWithNamespace());
        modelProject.setOnlyAllowMergeIfAllDiscussionsAreResolved(project.getOnlyAllowMergeIfAllDiscussionsAreResolved());
        modelProject.setOpenIssuesCount(project.getOpenIssuesCount());
        org.gitlab4j.api.models.Owner owner = project.getOwner();
        if (owner != null) {
            Owner modelOwner = this.createOwner(owner, progressMonitor);
            this.populateAbstractUser((org.gitlab4j.api.models.AbstractUser<?>)owner, modelOwner);
            modelProject.setOwner(modelOwner);
        }
        modelProject.setPath(project.getPath());
        modelProject.setPathWithNamespace(project.getPathWithNamespace());
        Permissions permissions = project.getPermissions();
        if (permissions != null) {
            Object projectAccess;
            org.gitlab4j.api.models.ProjectAccess groupAccess = permissions.getGroupAccess();
            if (groupAccess != null) {
                ProjectAccess modelGroupAccess = this.getFactory().createProjectAccess();
                modelGroupAccess.setAccessLevel(AccessLevel.get(groupAccess.getAccessLevel().value));
                modelProject.setGroupAccess(modelGroupAccess);
            }
            if ((projectAccess = permissions.getProjectAccess()) != null) {
                ProjectAccess modelProjectAccess = this.getFactory().createProjectAccess();
                modelProjectAccess.setAccessLevel(AccessLevel.get(projectAccess.getAccessLevel().value));
                modelProject.setGroupAccess(modelProjectAccess);
            }
        }
        modelProject.setPublicJobs(project.getPublicJobs());
        modelProject.setRepositoryStorage(project.getRepositoryStorage());
        modelProject.setRequestAccessEnabled(project.getRequestAccessEnabled());
        modelProject.setRunnersToken(project.getRunnersToken());
        modelProject.setSharedRunnersEnabled(project.getSharedRunnersEnabled());
        List sharedGroups = project.getSharedWithGroups();
        if (sharedGroups != null) {
            for (org.gitlab4j.api.models.ProjectSharedGroup sg : sharedGroups) {
                ProjectSharedGroup psg = this.getFactory().createProjectSharedGroup();
                org.gitlab4j.api.models.AccessLevel accessLevel = sg.getGroupAccessLevel();
                if (accessLevel != null) {
                    psg.setAccessLevel(AccessLevel.get(accessLevel.value));
                }
                psg.setFullPath(sg.getGroupFullPath());
                psg.setId(sg.getGroupId());
                psg.setName(sg.getGroupName());
                groupProvider.apply(sg.getGroupId()).thenAccept(psg::setGroup);
            }
        }
        modelProject.setSnippetsEnabled(project.getSnippetsEnabled());
        modelProject.setSshUrlToRepo(project.getSshUrlToRepo());
        modelProject.setStarCount(project.getStarCount());
        List tags = project.getTagList();
        if (tags != null) {
            modelProject.getTags().addAll((Collection)tags);
        }
        modelProject.setVisibilityLevel(project.getVisibilityLevel());
        org.gitlab4j.api.models.Visibility projectVisibility = project.getVisibility();
        if (projectVisibility != null) {
            modelProject.setVisibility(Visibility.get(projectVisibility.ordinal()));
        }
        modelProject.setWallEnabled(project.getWallEnabled());
        modelProject.setWebUrl(project.getWebUrl());
        modelProject.setWikiEnabled(project.getWikiEnabled());
        modelProject.setPrintingMergeRequestLinkEnabled(project.getPrintingMergeRequestLinkEnabled());
        modelProject.setResolveOutdatedDiffDiscussions(project.getResolveOutdatedDiffDiscussions());
        org.gitlab4j.api.models.ProjectStatistics projectStatistics = project.getStatistics();
        if (projectStatistics != null) {
            ProjectStatistics modelProjectStatistics = this.getFactory().createProjectStatistics();
            modelProjectStatistics.setCommitCount(projectStatistics.getCommitCount());
            modelProjectStatistics.setJobArtifactsSize(projectStatistics.getJobArtifactsSize());
            modelProjectStatistics.setLfsObjectsSize(projectStatistics.getLfsObjectsSize());
            modelProjectStatistics.setPackagesSize(projectStatistics.getPackagesSize());
            modelProjectStatistics.setRepositorySize(projectStatistics.getRepositorySize());
            modelProjectStatistics.setStorageSize(projectStatistics.getStorageSize());
            modelProjectStatistics.setWikiSize(projectStatistics.getWikiSize());
            modelProject.setStatistics(modelProjectStatistics);
        }
        modelProject.setInitializeWithReadme(null);
        modelProject.setPackagesEnabled(null);
        modelProject.setEmptyRepo(null);
        modelProject.setLicenseUrl(null);
        org.gitlab4j.api.ProjectLicense apiLicense = project.getLicense();
        if (apiLicense != null) {
            modelProject.setLicense(this.loadProjectLicense(apiLicense, progressMonitor));
        }
        if ((apiCustomAttributes = project.getCustomAttributes()) != null) {
            EMap<String, String> modelCustomAttributes = modelProject.getCustomAttributes();
            apiCustomAttributes.forEach(ca -> modelCustomAttributes.put((Object)ca.getKey(), (Object)ca.getValue()));
        }
        modelProject.setBuildCoverageRegex(project.getBuildCoverageRegex());
        Constants.BuildGitStrategy buildGitStrategy = project.getBuildGitStrategy();
        if (buildGitStrategy != null) {
            modelProject.setBuildGitStrategy(BuildGitStrategy.get(buildGitStrategy.ordinal()));
        }
        modelProject.setReadmeUrl(project.getReadmeUrl());
        modelProject.setCanCreateMergeRequestIn(project.getCanCreateMergeRequestIn());
        ImportStatus.Status importStatus = project.getImportStatus();
        if (importStatus != null) {
            modelProject.setImportStatus(Status.get(importStatus.ordinal()));
        }
        modelProject.setCiDefaultGitDepth(project.getCiDefaultGitDepth());
        modelProject.setCiForwardDeploymentEnabled(project.getCiForwardDeploymentEnabled());
        modelProject.setCiConfigPath(project.getCiConfigPath());
        modelProject.setRemoveSourceBranchAfterMerge(project.getRemoveSourceBranchAfterMerge());
        modelProject.setAutoDevopsEnabled(project.getAutoDevopsEnabled());
        Constants.AutoDevopsDeployStrategy autoDevopsDeployStrategy = project.getAutoDevopsDeployStrategy();
        if (autoDevopsDeployStrategy != null) {
            modelProject.setAutoDevopsDeployStrategy(AutoDevopsDeployStrategy.get(autoDevopsDeployStrategy.ordinal()));
        }
        modelProject.setAutocloseReferencedIssues(project.getAutocloseReferencedIssues());
        modelProject.setEmailsDisabled(project.getEmailsDisabled());
        modelProject.setSuggestionCommitMessage(project.getSuggestionCommitMessage());
        Constants.SquashOption squashOption = project.getSquashOption();
        if (squashOption != null) {
            modelProject.setSquashOption(SquashOption.get(squashOption.ordinal()));
        }
        RepositoryApi repoApi = this.gitLabApi.getRepositoryApi();
        try {
            List branches = repoApi.getBranches((Object)project.getId());
            if (branches != null) {
                EList<Branch> modelBranches = modelProject.getBranches();
                for (org.gitlab4j.api.models.Branch branch : branches) {
                    Branch modelBranch = this.createBranch(branch, progressMonitor);
                    modelBranch.setCanPush(branch.getCanPush());
                    Commit commit = branch.getCommit();
                    if (commit != null) {
                        modelBranch.setCommitDate(commit.getCommittedDate());
                    }
                    modelBranch.setDevelopersCanMerge(branch.getDevelopersCanMerge());
                    modelBranch.setDevelopersCanPush(branch.getDevelopersCanPush());
                    modelBranch.setIsDefault(branch.getDefault());
                    modelBranch.setIsProtected(branch.getProtected());
                    modelBranch.setMerged(branch.getMerged());
                    modelBranch.setName(branch.getName());
                    modelBranch.setWebUrl(branch.getWebUrl());
                    modelBranches.add((Object)modelBranch);
                    if (!this.isLoadPath(modelProject, modelBranch, ROOT_PATH)) continue;
                    modelBranch.getTreeItems().addAll(this.loadTree(modelProject, modelBranch, ROOT_PATH, groupProvider, projectProvider, progressMonitor));
                }
            }
        }
        catch (GitLabApiException e) {
            progressMonitor.worked(org.nasdanika.common.Status.ERROR, 1.0, "Failed to load branches", new Object[]{project, e});
        }
        try {
            List contributors = repoApi.getContributors((Object)project.getId());
            if (contributors != null) {
                EList<Contributor> modelContributors = modelProject.getContributors();
                for (org.gitlab4j.api.models.Contributor contributor : contributors) {
                    Contributor modelContributor = this.createContributor(contributor, progressMonitor);
                    this.populateAbstractUser((org.gitlab4j.api.models.AbstractUser<?>)contributor, modelContributor);
                    modelContributor.setAdditions(contributor.getAdditions());
                    modelContributor.setCommits(contributor.getCommits());
                    modelContributor.setDeletions(contributor.getDeletions());
                    modelContributors.add((Object)modelContributor);
                }
            }
        }
        catch (GitLabApiException e) {
            progressMonitor.worked(org.nasdanika.common.Status.ERROR, 1.0, "Failed to load contributors", new Object[]{project, e});
        }
        try {
            ProjectApi projectApi = this.gitLabApi.getProjectApi();
            List projectMembers = projectApi.getMembers((Object)project.getId());
            EList<Member> modelProjectMembers = modelProject.getMembers();
            for (org.gitlab4j.api.models.Member member : projectMembers) {
                Member modelMember = this.loadMember(member, progressMonitor);
                modelProjectMembers.add((Object)modelMember);
            }
        }
        catch (GitLabApiException e) {
            progressMonitor.worked(org.nasdanika.common.Status.ERROR, 1.0, "Failed to load members", new Object[]{project, e});
        }
        return modelProject;
    }

    protected List<TreeItem> loadTree(Project modelProject, Branch modelBranch, String path, Function<Long, CompletableFuture<Group>> groupProvider, Function<Long, CompletableFuture<Project>> projectProvider, ProgressMonitor progressMonitor) throws GitLabApiException {
        ArrayList<TreeItem> ret = new ArrayList<TreeItem>();
        RepositoryApi repoApi = this.gitLabApi.getRepositoryApi();
        for (org.gitlab4j.api.models.TreeItem treeItem : repoApi.getTree((Object)modelProject.getId(), path, modelBranch.getName())) {
            if (!this.isLoadPath(modelProject, modelBranch, path)) continue;
            switch (treeItem.getType()) {
                case TREE: {
                    Tree subTree = this.createTree(modelProject, modelBranch, treeItem);
                    subTree.setId(treeItem.getId());
                    subTree.setName(treeItem.getName());
                    subTree.setPath(treeItem.getPath());
                    subTree.getTreeItems().addAll(this.loadTree(modelProject, modelBranch, treeItem.getPath(), groupProvider, projectProvider, progressMonitor));
                    ret.add(subTree);
                    break;
                }
                case BLOB: {
                    Blob blob = this.createBlob(modelProject, modelBranch, treeItem, groupProvider, projectProvider, progressMonitor);
                    if (blob == null) break;
                    blob.setId(treeItem.getId());
                    blob.setName(treeItem.getName());
                    blob.setPath(treeItem.getPath());
                    ret.add(blob);
                    break;
                }
                case COMMIT: {
                    break;
                }
            }
        }
        return ret;
    }

    protected Tree createTree(Project modelProject, Branch modelBranch, org.gitlab4j.api.models.TreeItem tree) {
        return this.getFactory().createTree();
    }

    protected boolean isLoadPath(Project modelProject, Branch modelBranch, String path) {
        return false;
    }

    protected Blob createBlob(Project modelProject, Branch modelBranch, org.gitlab4j.api.models.TreeItem blob, Function<Long, CompletableFuture<Group>> groupProvider, Function<Long, CompletableFuture<Project>> projectProvider, ProgressMonitor progressMonitor) throws GitLabApiException {
        RepositoryFileApi repoFileApi = this.gitLabApi.getRepositoryFileApi();
        org.gitlab4j.api.models.RepositoryFile repoFile = repoFileApi.getFile((Object)modelProject.getId(), blob.getPath(), modelBranch.getName());
        RepositoryFile ret = this.createRepositoryFile(modelProject, modelBranch, blob, repoFile, groupProvider, projectProvider, progressMonitor);
        ret.setCommitId(ret.getCommitId());
        ret.setLastCommitId(ret.getLastCommitId());
        ret.setRef(ret.getRef());
        ret.setSize(ret.getSize());
        return ret;
    }

    protected RepositoryFile createRepositoryFile(Project modelProject, Branch modelBranch, org.gitlab4j.api.models.TreeItem blob, org.gitlab4j.api.models.RepositoryFile repositoryFile, Function<Long, CompletableFuture<Group>> groupProvider, Function<Long, CompletableFuture<Project>> projectProvider, ProgressMonitor progressMonitor) {
        return this.getFactory().createRepositoryFile();
    }

    protected Member loadMember(org.gitlab4j.api.models.Member member, ProgressMonitor progressMonitor) {
        Member modelMember = this.getFactory().createMember();
        this.populateAbstractUser((org.gitlab4j.api.models.AbstractUser<?>)member, modelMember);
        org.gitlab4j.api.models.AccessLevel accessLevel = member.getAccessLevel();
        if (accessLevel != null) {
            modelMember.setAccessLevel(AccessLevel.get(accessLevel.value));
        }
        modelMember.setExpiresAt(member.getExpiresAt());
        return modelMember;
    }

    @Override
    public void close() {
        if (this.gitLabApi != null) {
            this.gitLabApi.close();
        }
    }
}

