/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.models.gitlab.util;

import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import org.eclipse.emf.common.util.EMap;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GroupApi;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.ProjectApi;
import org.gitlab4j.api.RepositoryApi;
import org.gitlab4j.api.RepositoryFileApi;
import org.gitlab4j.api.models.Commit;
import org.gitlab4j.api.models.Group;
import org.gitlab4j.api.models.GroupFilter;
import org.gitlab4j.api.models.ImportStatus;
import org.gitlab4j.api.models.Permissions;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.models.gitlab.AbstractUser;
import org.nasdanika.models.gitlab.AccessLevel;
import org.nasdanika.models.gitlab.AutoDevopsDeployStrategy;
import org.nasdanika.models.gitlab.Blob;
import org.nasdanika.models.gitlab.Branch;
import org.nasdanika.models.gitlab.BuildGitStrategy;
import org.nasdanika.models.gitlab.Contributor;
import org.nasdanika.models.gitlab.GitLabFactory;
import org.nasdanika.models.gitlab.Group;
import org.nasdanika.models.gitlab.Member;
import org.nasdanika.models.gitlab.MergeMethod;
import org.nasdanika.models.gitlab.Owner;
import org.nasdanika.models.gitlab.Project;
import org.nasdanika.models.gitlab.ProjectAccess;
import org.nasdanika.models.gitlab.ProjectLicense;
import org.nasdanika.models.gitlab.ProjectSharedGroup;
import org.nasdanika.models.gitlab.ProjectStatistics;
import org.nasdanika.models.gitlab.RepositoryFile;
import org.nasdanika.models.gitlab.SquashOption;
import org.nasdanika.models.gitlab.Status;
import org.nasdanika.models.gitlab.Tree;
import org.nasdanika.models.gitlab.TreeItem;
import org.nasdanika.models.gitlab.Visibility;

public class Loader {
    public static final String ROOT_PATH = "/";
    private GitLabApi gitLabApi;
    private GitLabFactory factory = GitLabFactory.eINSTANCE;
    private int pageSize = 20;

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public GitLabApi getGitLabApi() {
        return this.gitLabApi;
    }

    public Loader(GitLabApi gitLabApi) {
        this.gitLabApi = gitLabApi;
    }

    public GitLabFactory getFactory() {
        return this.factory;
    }

    public void setFactory(GitLabFactory factory) {
        this.factory = factory;
    }

    protected GroupFilter getGroupFilter() {
        return new GroupFilter();
    }

    public void loadTopLevelGroups(BiConsumer<Group, ProgressMonitor> groupConsumer, ProgressMonitor progressMonitor) throws GitLabApiException {
        try (ProgressMonitor groupsMonitor = progressMonitor.split("Loading top-level groups", 1.0, new Object[0]);){
            GroupApi groupApi = this.gitLabApi.getGroupApi();
            Pager groupPager = groupApi.getGroups(this.getGroupFilter().withTopLevelOnly(Boolean.valueOf(true)), this.getPageSize());
            this.loadGroupPager(groupApi, (Pager<org.gitlab4j.api.models.Group>)groupPager, groupConsumer, groupsMonitor);
        }
    }

    public void loadSubGroups(long groupId, BiConsumer<Group, ProgressMonitor> groupConsumer, ProgressMonitor progressMonitor) throws GitLabApiException {
        try (ProgressMonitor groupsMonitor = progressMonitor.split("Loading sub-groups of " + groupId, 1.0, new Object[0]);){
            GroupApi groupApi = this.gitLabApi.getGroupApi();
            Pager groupPager = groupApi.getDescendantGroups((Object)groupId, this.getGroupFilter(), this.getPageSize());
            this.loadGroupPager(groupApi, (Pager<org.gitlab4j.api.models.Group>)groupPager, groupConsumer, groupsMonitor);
        }
    }

    protected void loadGroupPager(GroupApi groupApi, Pager<org.gitlab4j.api.models.Group> groupPager, BiConsumer<Group, ProgressMonitor> groupConsumer, ProgressMonitor groupsMonitor) throws GitLabApiException {
        int pageNum = 0;
        while (groupPager.hasNext()) {
            double monitorSize = 1.0 / Math.pow(2.0, ++pageNum);
            ProgressMonitor groupPageMonitor = groupsMonitor.split("Group page " + pageNum, monitorSize, new Object[0]);
            try {
                List groups = groupPager.next();
                ProgressMonitor scaledGroupsMonitor = groupPageMonitor.scale((double)(groups.size() * 2 + 1));
                try {
                    scaledGroupsMonitor.worked(org.nasdanika.common.Status.INFO, 1.0, "Retrieved " + groups.size() + " groups", new Object[0]);
                    for (org.gitlab4j.api.models.Group group : groups) {
                        ProgressMonitor groupMonitor = scaledGroupsMonitor.split("Loading group " + group.getName() + " " + group.getId(), 2.0, new Object[]{group});
                        try {
                            Group modelGroup = this.loadGroup(group, groupApi, groupMonitor.split("Loading group data and members", 1.0, new Object[0]));
                            groupConsumer.accept(modelGroup, groupMonitor.split("Consuming group", 1.0, new Object[0]));
                        }
                        finally {
                            if (groupMonitor == null) continue;
                            groupMonitor.close();
                        }
                    }
                }
                finally {
                    if (scaledGroupsMonitor == null) continue;
                    scaledGroupsMonitor.close();
                }
            }
            finally {
                if (groupPageMonitor == null) continue;
                groupPageMonitor.close();
            }
        }
    }

    protected Group createGroup(org.gitlab4j.api.models.Group group, ProgressMonitor progressMonitor) {
        return this.getFactory().createGroup();
    }

    protected Group loadGroup(org.gitlab4j.api.models.Group group, GroupApi groupApi, ProgressMonitor progressMonitor) throws GitLabApiException {
        Group modelGroup = this.createGroup(group, progressMonitor);
        modelGroup.setAvatarUrl(group.getAvatarUrl());
        modelGroup.setCreatedAt(group.getCreatedAt());
        modelGroup.setDescription(group.getDescription());
        modelGroup.setFullName(group.getFullName());
        modelGroup.setFullPath(group.getFullPath());
        modelGroup.setId(group.getId());
        Group.Statistics stats = group.getStatistics();
        if (stats != null) {
            modelGroup.setJobArtifactsSize(stats.getJobArtifactsSize());
            modelGroup.setLfsObjectsSize(stats.getLfsObjectsSize());
            modelGroup.setRepositorySize(stats.getRepositorySize());
            modelGroup.setStorageSize(stats.getStorageSize());
        }
        modelGroup.setLfsEnabled(group.getLfsEnabled());
        modelGroup.setName(group.getName());
        modelGroup.setPath(group.getPath());
        modelGroup.setVisibility(Visibility.get(group.getVisibility().ordinal()));
        modelGroup.setWebUrl(group.getWebUrl());
        return modelGroup;
    }

    public void loadGroupMembers(long groupId, BiConsumer<Member, ProgressMonitor> memberConsumer, ProgressMonitor progressMonitor) throws GitLabApiException {
        try (ProgressMonitor membersMonitor = progressMonitor.split("Loading group members of " + groupId, 1.0, new Object[0]);){
            GroupApi groupApi = this.gitLabApi.getGroupApi();
            Pager memberPager = groupApi.getMembers((Object)groupId, this.getPageSize());
            int pageNum = 0;
            while (memberPager.hasNext()) {
                double monitorSize = 1.0 / Math.pow(2.0, ++pageNum);
                ProgressMonitor memberPageMonitor = membersMonitor.split("Group members page " + pageNum, monitorSize, new Object[0]);
                try {
                    List members = memberPager.next();
                    ProgressMonitor scaledMembersMonitor = memberPageMonitor.scale((double)(members.size() * 2 + 1));
                    try {
                        scaledMembersMonitor.worked(org.nasdanika.common.Status.INFO, 1.0, "Retrieved " + members.size() + " members", new Object[0]);
                        for (org.gitlab4j.api.models.Member member : members) {
                            ProgressMonitor memberMonitor = scaledMembersMonitor.split("Loading member " + member.getName() + " " + member.getId(), 2.0, new Object[]{member});
                            try {
                                Member modelMember = this.loadMember(member, memberMonitor.split("Loading member data", 1.0, new Object[0]));
                                memberConsumer.accept(modelMember, memberMonitor.split("Consuming member", 1.0, new Object[0]));
                            }
                            finally {
                                if (memberMonitor == null) continue;
                                memberMonitor.close();
                            }
                        }
                    }
                    finally {
                        if (scaledMembersMonitor == null) continue;
                        scaledMembersMonitor.close();
                    }
                }
                finally {
                    if (memberPageMonitor == null) continue;
                    memberPageMonitor.close();
                }
            }
        }
    }

    protected void populateAbstractUser(org.gitlab4j.api.models.AbstractUser<?> apiUser, AbstractUser user) {
        user.setAvatarUrl(apiUser.getAvatarUrl());
        user.setCreatedAt(apiUser.getCreatedAt());
        user.setEMail(apiUser.getEmail());
        user.setId(apiUser.getId());
        user.setName(apiUser.getName());
        user.setState(apiUser.getState());
        user.setUserName(apiUser.getUsername());
        user.setWebUrl(apiUser.getWebUrl());
    }

    protected Member loadMember(org.gitlab4j.api.models.Member member, ProgressMonitor progressMonitor) {
        Member modelMember = this.getFactory().createMember();
        this.populateAbstractUser((org.gitlab4j.api.models.AbstractUser<?>)member, modelMember);
        org.gitlab4j.api.models.AccessLevel accessLevel = member.getAccessLevel();
        if (accessLevel != null) {
            modelMember.setAccessLevel(AccessLevel.get(accessLevel.value));
        }
        modelMember.setExpiresAt(member.getExpiresAt());
        return modelMember;
    }

    public void loadProjects(long groupId, BiConsumer<Project, ProgressMonitor> projectConsumer, ProgressMonitor progressMonitor) throws GitLabApiException {
        try (ProgressMonitor projectsMonitor = progressMonitor.split("Loading projects of " + groupId, 1.0, new Object[0]);){
            GroupApi groupApi = this.gitLabApi.getGroupApi();
            Pager projectPager = groupApi.getProjects((Object)groupId, this.getPageSize());
            int pageNum = 0;
            while (projectPager.hasNext()) {
                double monitorSize = 1.0 / Math.pow(2.0, ++pageNum);
                ProgressMonitor projectPageMonitor = projectsMonitor.split("Project page " + pageNum, monitorSize, new Object[0]);
                try {
                    List projects = projectPager.next();
                    ProgressMonitor scaledProjectsMonitor = projectPageMonitor.scale((double)(projects.size() * 2 + 1));
                    try {
                        scaledProjectsMonitor.worked(org.nasdanika.common.Status.INFO, 1.0, "Retrieved " + projects.size() + " projects", new Object[0]);
                        for (org.gitlab4j.api.models.Project project : projects) {
                            ProgressMonitor projectMonitor = scaledProjectsMonitor.split("Loading project " + project.getName() + " " + project.getId(), 2.0, new Object[]{project});
                            try {
                                Project modelProject = this.loadProject(project, projectMonitor.split("Loading project data", 1.0, new Object[0]));
                                projectConsumer.accept(modelProject, projectMonitor.split("Consuming project", 1.0, new Object[0]));
                            }
                            finally {
                                if (projectMonitor == null) continue;
                                projectMonitor.close();
                            }
                        }
                    }
                    finally {
                        if (scaledProjectsMonitor == null) continue;
                        scaledProjectsMonitor.close();
                    }
                }
                finally {
                    if (projectPageMonitor == null) continue;
                    projectPageMonitor.close();
                }
            }
        }
    }

    protected Project createProject(org.gitlab4j.api.models.Project project, ProgressMonitor progressMonitor) {
        return this.getFactory().createProject();
    }

    protected Owner createOwner(org.gitlab4j.api.models.Owner owner, ProgressMonitor progressMonitor) {
        return this.getFactory().createOwner();
    }

    protected Branch createBranch(org.gitlab4j.api.models.Branch branch, ProgressMonitor progressMonitor) {
        return this.getFactory().createBranch();
    }

    protected Contributor createContributor(org.gitlab4j.api.models.Contributor contributor, ProgressMonitor progressMonitor) {
        return this.getFactory().createContributor();
    }

    protected ProjectLicense loadProjectLicense(org.gitlab4j.api.ProjectLicense apiLicense, ProgressMonitor progressMonitor) {
        ProjectLicense modelLicense = this.getFactory().createProjectLicense();
        modelLicense.setHtmlUrl(apiLicense.getHtmlUrl());
        modelLicense.setKey(apiLicense.getKey());
        modelLicense.setName(apiLicense.getName());
        modelLicense.setNickname(apiLicense.getNickname());
        modelLicense.setSourceUrl(apiLicense.getSourceUrl());
        return modelLicense;
    }

    protected Project loadProject(org.gitlab4j.api.models.Project project, ProgressMonitor progressMonitor) throws GitLabApiException {
        List apiCustomAttributes;
        Project modelProject = this.createProject(project, progressMonitor);
        modelProject.setId(project.getId());
        modelProject.setApprovalsBeforeMerge(project.getApprovalsBeforeMerge());
        modelProject.setArchived(project.getArchived());
        modelProject.setAvatarUrl(project.getAvatarUrl());
        modelProject.setContainerRegistryEnabled(project.getContainerRegistryEnabled());
        modelProject.setCreatedAt(project.getCreatedAt());
        modelProject.setCreatorId(project.getCreatorId());
        modelProject.setDefaultBranch(project.getDefaultBranch());
        modelProject.setDescription(project.getDescription());
        modelProject.setForksCount(project.getForksCount());
        org.gitlab4j.api.models.Project forkedFromProject = project.getForkedFromProject();
        if (forkedFromProject != null) {
            modelProject.setForkedFromId(forkedFromProject.getId());
        }
        modelProject.setHttpUrlToRepo(project.getHttpUrlToRepo());
        modelProject.setIsPublic(project.getPublic());
        modelProject.setIssuesEnabled(project.getIssuesEnabled());
        modelProject.setJobsEnabled(project.getJobsEnabled());
        modelProject.setLastsActivityAt(project.getLastActivityAt());
        modelProject.setLfsEnabled(project.getLfsEnabled());
        modelProject.setMergeMethod(MergeMethod.get(project.getMergeMethod().ordinal()));
        modelProject.setMergeRequestsEnabled(project.getMergeRequestsEnabled());
        modelProject.setName(project.getName());
        modelProject.setNameWithNamespace(project.getNameWithNamespace());
        modelProject.setOnlyAllowMergeIfAllDiscussionsAreResolved(project.getOnlyAllowMergeIfAllDiscussionsAreResolved());
        modelProject.setOpenIssuesCount(project.getOpenIssuesCount());
        org.gitlab4j.api.models.Owner owner = project.getOwner();
        if (owner != null) {
            Owner modelOwner = this.createOwner(owner, progressMonitor);
            this.populateAbstractUser((org.gitlab4j.api.models.AbstractUser<?>)owner, modelOwner);
            modelProject.setOwner(modelOwner);
        }
        modelProject.setPath(project.getPath());
        modelProject.setPathWithNamespace(project.getPathWithNamespace());
        Permissions permissions = project.getPermissions();
        if (permissions != null) {
            Object projectAccess;
            org.gitlab4j.api.models.ProjectAccess groupAccess = permissions.getGroupAccess();
            if (groupAccess != null) {
                ProjectAccess modelGroupAccess = this.getFactory().createProjectAccess();
                modelGroupAccess.setAccessLevel(AccessLevel.get(groupAccess.getAccessLevel().value));
                modelProject.setGroupAccess(modelGroupAccess);
            }
            if ((projectAccess = permissions.getProjectAccess()) != null) {
                ProjectAccess modelProjectAccess = this.getFactory().createProjectAccess();
                modelProjectAccess.setAccessLevel(AccessLevel.get(projectAccess.getAccessLevel().value));
                modelProject.setGroupAccess(modelProjectAccess);
            }
        }
        modelProject.setPublicJobs(project.getPublicJobs());
        modelProject.setRepositoryStorage(project.getRepositoryStorage());
        modelProject.setRequestAccessEnabled(project.getRequestAccessEnabled());
        modelProject.setRunnersToken(project.getRunnersToken());
        modelProject.setSharedRunnersEnabled(project.getSharedRunnersEnabled());
        List sharedGroups = project.getSharedWithGroups();
        if (sharedGroups != null) {
            for (org.gitlab4j.api.models.ProjectSharedGroup sg : sharedGroups) {
                ProjectSharedGroup psg = this.getFactory().createProjectSharedGroup();
                org.gitlab4j.api.models.AccessLevel accessLevel = sg.getGroupAccessLevel();
                if (accessLevel != null) {
                    psg.setAccessLevel(AccessLevel.get(accessLevel.value));
                }
                psg.setFullPath(sg.getGroupFullPath());
                psg.setId(sg.getGroupId());
                psg.setName(sg.getGroupName());
            }
        }
        modelProject.setSnippetsEnabled(project.getSnippetsEnabled());
        modelProject.setSshUrlToRepo(project.getSshUrlToRepo());
        modelProject.setStarCount(project.getStarCount());
        List tags = project.getTagList();
        if (tags != null) {
            modelProject.getTags().addAll((Collection)tags);
        }
        modelProject.setVisibilityLevel(project.getVisibilityLevel());
        org.gitlab4j.api.models.Visibility projectVisibility = project.getVisibility();
        if (projectVisibility != null) {
            modelProject.setVisibility(Visibility.get(projectVisibility.ordinal()));
        }
        modelProject.setWallEnabled(project.getWallEnabled());
        modelProject.setWebUrl(project.getWebUrl());
        modelProject.setWikiEnabled(project.getWikiEnabled());
        modelProject.setPrintingMergeRequestLinkEnabled(project.getPrintingMergeRequestLinkEnabled());
        modelProject.setResolveOutdatedDiffDiscussions(project.getResolveOutdatedDiffDiscussions());
        org.gitlab4j.api.models.ProjectStatistics projectStatistics = project.getStatistics();
        if (projectStatistics != null) {
            ProjectStatistics modelProjectStatistics = this.getFactory().createProjectStatistics();
            modelProjectStatistics.setCommitCount(projectStatistics.getCommitCount());
            modelProjectStatistics.setJobArtifactsSize(projectStatistics.getJobArtifactsSize());
            modelProjectStatistics.setLfsObjectsSize(projectStatistics.getLfsObjectsSize());
            modelProjectStatistics.setPackagesSize(projectStatistics.getPackagesSize());
            modelProjectStatistics.setRepositorySize(projectStatistics.getRepositorySize());
            modelProjectStatistics.setStorageSize(projectStatistics.getStorageSize());
            modelProjectStatistics.setWikiSize(projectStatistics.getWikiSize());
            modelProject.setStatistics(modelProjectStatistics);
        }
        modelProject.setInitializeWithReadme(null);
        modelProject.setPackagesEnabled(null);
        modelProject.setEmptyRepo(null);
        modelProject.setLicenseUrl(null);
        org.gitlab4j.api.ProjectLicense apiLicense = project.getLicense();
        if (apiLicense != null) {
            modelProject.setLicense(this.loadProjectLicense(apiLicense, progressMonitor));
        }
        if ((apiCustomAttributes = project.getCustomAttributes()) != null) {
            EMap<String, String> modelCustomAttributes = modelProject.getCustomAttributes();
            apiCustomAttributes.forEach(ca -> modelCustomAttributes.put((Object)ca.getKey(), (Object)ca.getValue()));
        }
        modelProject.setBuildCoverageRegex(project.getBuildCoverageRegex());
        Constants.BuildGitStrategy buildGitStrategy = project.getBuildGitStrategy();
        if (buildGitStrategy != null) {
            modelProject.setBuildGitStrategy(BuildGitStrategy.get(buildGitStrategy.ordinal()));
        }
        modelProject.setReadmeUrl(project.getReadmeUrl());
        modelProject.setCanCreateMergeRequestIn(project.getCanCreateMergeRequestIn());
        ImportStatus.Status importStatus = project.getImportStatus();
        if (importStatus != null) {
            modelProject.setImportStatus(Status.get(importStatus.ordinal()));
        }
        modelProject.setCiDefaultGitDepth(project.getCiDefaultGitDepth());
        modelProject.setCiForwardDeploymentEnabled(project.getCiForwardDeploymentEnabled());
        modelProject.setCiConfigPath(project.getCiConfigPath());
        modelProject.setRemoveSourceBranchAfterMerge(project.getRemoveSourceBranchAfterMerge());
        modelProject.setAutoDevopsEnabled(project.getAutoDevopsEnabled());
        Constants.AutoDevopsDeployStrategy autoDevopsDeployStrategy = project.getAutoDevopsDeployStrategy();
        if (autoDevopsDeployStrategy != null) {
            modelProject.setAutoDevopsDeployStrategy(AutoDevopsDeployStrategy.get(autoDevopsDeployStrategy.ordinal()));
        }
        modelProject.setAutocloseReferencedIssues(project.getAutocloseReferencedIssues());
        modelProject.setEmailsDisabled(project.getEmailsDisabled());
        modelProject.setSuggestionCommitMessage(project.getSuggestionCommitMessage());
        Constants.SquashOption squashOption = project.getSquashOption();
        if (squashOption != null) {
            modelProject.setSquashOption(SquashOption.get(squashOption.ordinal()));
        }
        return modelProject;
    }

    public void loadProjectMembers(long projectId, BiConsumer<Member, ProgressMonitor> memberConsumer, ProgressMonitor progressMonitor) throws GitLabApiException {
        try (ProgressMonitor membersMonitor = progressMonitor.split("Loading project members of " + projectId, 1.0, new Object[0]);){
            ProjectApi projectApi = this.gitLabApi.getProjectApi();
            Pager memberPager = projectApi.getMembers((Object)projectId, this.getPageSize());
            int pageNum = 0;
            while (memberPager.hasNext()) {
                double monitorSize = 1.0 / Math.pow(2.0, ++pageNum);
                ProgressMonitor memberPageMonitor = membersMonitor.split("Project members page " + pageNum, monitorSize, new Object[0]);
                try {
                    List members = memberPager.next();
                    ProgressMonitor scaledMembersMonitor = memberPageMonitor.scale((double)(members.size() * 2 + 1));
                    try {
                        scaledMembersMonitor.worked(org.nasdanika.common.Status.INFO, 1.0, "Retrieved " + members.size() + " members", new Object[0]);
                        for (org.gitlab4j.api.models.Member member : members) {
                            ProgressMonitor memberMonitor = scaledMembersMonitor.split("Loading member " + member.getName() + " " + member.getId(), 2.0, new Object[]{member});
                            try {
                                Member modelMember = this.loadMember(member, memberMonitor.split("Loading member data", 1.0, new Object[0]));
                                memberConsumer.accept(modelMember, memberMonitor.split("Consuming member", 1.0, new Object[0]));
                            }
                            finally {
                                if (memberMonitor == null) continue;
                                memberMonitor.close();
                            }
                        }
                    }
                    finally {
                        if (scaledMembersMonitor == null) continue;
                        scaledMembersMonitor.close();
                    }
                }
                finally {
                    if (memberPageMonitor == null) continue;
                    memberPageMonitor.close();
                }
            }
        }
    }

    public void loadProjectContributors(long projectId, BiConsumer<Contributor, ProgressMonitor> contributorConsumer, ProgressMonitor progressMonitor) throws GitLabApiException {
        try (ProgressMonitor contributorsMonitor = progressMonitor.split("Loading project contributors of " + projectId, 1.0, new Object[0]);){
            RepositoryApi repoApi = this.gitLabApi.getRepositoryApi();
            Pager contributorPager = repoApi.getContributors((Object)projectId, this.getPageSize());
            int pageNum = 0;
            while (contributorPager.hasNext()) {
                double monitorSize = 1.0 / Math.pow(2.0, ++pageNum);
                ProgressMonitor contributorPageMonitor = contributorsMonitor.split("Project contributors page " + pageNum, monitorSize, new Object[0]);
                try {
                    List contributors = contributorPager.next();
                    ProgressMonitor scaledContributorsMonitor = contributorPageMonitor.scale((double)(contributors.size() + 1));
                    try {
                        scaledContributorsMonitor.worked(org.nasdanika.common.Status.INFO, 1.0, "Retrieved " + contributors.size() + " contributors", new Object[0]);
                        for (org.gitlab4j.api.models.Contributor contributor : contributors) {
                            ProgressMonitor contributorMonitor = scaledContributorsMonitor.split("Loading contributor " + contributor.getName() + " " + contributor.getId(), 1.0, new Object[]{contributor});
                            try {
                                Contributor modelContributor = this.createContributor(contributor, contributorMonitor);
                                this.populateAbstractUser((org.gitlab4j.api.models.AbstractUser<?>)contributor, modelContributor);
                                modelContributor.setAdditions(contributor.getAdditions());
                                modelContributor.setCommits(contributor.getCommits());
                                modelContributor.setDeletions(contributor.getDeletions());
                                contributorConsumer.accept(modelContributor, contributorMonitor);
                            }
                            finally {
                                if (contributorMonitor == null) continue;
                                contributorMonitor.close();
                            }
                        }
                    }
                    finally {
                        if (scaledContributorsMonitor == null) continue;
                        scaledContributorsMonitor.close();
                    }
                }
                finally {
                    if (contributorPageMonitor == null) continue;
                    contributorPageMonitor.close();
                }
            }
        }
    }

    public void loadBranches(long projectId, BiConsumer<Branch, ProgressMonitor> branchConsumer, ProgressMonitor progressMonitor) throws GitLabApiException {
        try (ProgressMonitor branchesMonitor = progressMonitor.split("Loading branches of " + projectId, 1.0, new Object[0]);){
            RepositoryApi repoApi = this.gitLabApi.getRepositoryApi();
            Pager branchPager = repoApi.getBranches((Object)projectId, this.getPageSize());
            int pageNum = 0;
            while (branchPager.hasNext()) {
                double monitorSize = 1.0 / Math.pow(2.0, ++pageNum);
                ProgressMonitor branchPageMonitor = branchesMonitor.split("Branch page " + pageNum, monitorSize, new Object[0]);
                try {
                    List branches = branchPager.next();
                    ProgressMonitor scaledBranchPageMonitor = branchPageMonitor.scale((double)(branches.size() + 1));
                    try {
                        scaledBranchPageMonitor.worked(org.nasdanika.common.Status.INFO, 1.0, "Retrieved " + branches.size() + " branches", new Object[0]);
                        for (org.gitlab4j.api.models.Branch branch : branches) {
                            ProgressMonitor branchMonitor = scaledBranchPageMonitor.split("Loading branch " + branch.getName(), 1.0, new Object[]{branch});
                            try {
                                Branch modelBranch = this.createBranch(branch, progressMonitor);
                                modelBranch.setCanPush(branch.getCanPush());
                                Commit commit = branch.getCommit();
                                if (commit != null) {
                                    modelBranch.setCommitDate(commit.getCommittedDate());
                                }
                                modelBranch.setDevelopersCanMerge(branch.getDevelopersCanMerge());
                                modelBranch.setDevelopersCanPush(branch.getDevelopersCanPush());
                                modelBranch.setIsDefault(branch.getDefault());
                                modelBranch.setIsProtected(branch.getProtected());
                                modelBranch.setMerged(branch.getMerged());
                                modelBranch.setName(branch.getName());
                                modelBranch.setWebUrl(branch.getWebUrl());
                                branchConsumer.accept(modelBranch, branchMonitor);
                            }
                            finally {
                                if (branchMonitor == null) continue;
                                branchMonitor.close();
                            }
                        }
                    }
                    finally {
                        if (scaledBranchPageMonitor == null) continue;
                        scaledBranchPageMonitor.close();
                    }
                }
                finally {
                    if (branchPageMonitor == null) continue;
                    branchPageMonitor.close();
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void loadTree(long projectId, String refName, String path, BiConsumer<TreeItem, ProgressMonitor> treeItemConsumer, ProgressMonitor progressMonitor) throws GitLabApiException {
        treeItemsMonitor = progressMonitor.split("Loading tree items of project: " + projectId + ", refName: " + refName + ", path: " + path, 1.0, new Object[0]);
        try {
            repoApi = this.gitLabApi.getRepositoryApi();
            treeItemPager = repoApi.getTree((Object)projectId, path, refName, this.getPageSize());
            pageNum = 0;
            while (treeItemPager.hasNext()) {
                monitorSize = 1.0 / Math.pow(2.0, ++pageNum);
                treeItemPagePageMonitor = treeItemsMonitor.split("Tree item page " + pageNum, monitorSize, new Object[0]);
                try {
                    treeItems = treeItemPager.next();
                    scaledTreeItemPageMonitor = treeItemPagePageMonitor.scale((double)(treeItems.size() + 1));
                    try {
                        scaledTreeItemPageMonitor.worked(org.nasdanika.common.Status.INFO, 1.0, "Retrieved " + treeItems.size() + " tree items", new Object[0]);
lbl14:
                        // 9 sources

                        block26: for (org.gitlab4j.api.models.TreeItem treeItem : treeItems) {
                            treeItemMonitor = scaledTreeItemPageMonitor.split("Loading tree item " + treeItem.getName(), 1.0, new Object[]{treeItem});
                            try {
                                switch (1.$SwitchMap$org$gitlab4j$api$models$TreeItem$Type[treeItem.getType().ordinal()]) {
                                    case 1: {
                                        subTree = this.createTree(projectId, refName, treeItem);
                                        if (subTree == null) ** break;
                                        subTree.setId(treeItem.getId());
                                        subTree.setName(treeItem.getName());
                                        subTree.setPath(treeItem.getPath());
                                        treeItemConsumer.accept(subTree, treeItemMonitor);
                                        ** break;
                                    }
                                    case 2: {
                                        blob = this.createBlob(projectId, refName, treeItem, progressMonitor);
                                        if (blob == null) ** break;
                                        blob.setId(treeItem.getId());
                                        blob.setName(treeItem.getName());
                                        blob.setPath(treeItem.getPath());
                                        treeItemConsumer.accept(blob, treeItemMonitor);
                                        ** break;
                                    }
                                    case 3: {
                                        ** break;
                                    }
                                    ** default:
lbl37:
                                    // 1 sources

                                    continue block26;
                                }
                            }
                            finally {
                                if (treeItemMonitor == null) continue;
                                treeItemMonitor.close();
                            }
                        }
                    }
                    finally {
                        if (scaledTreeItemPageMonitor == null) continue;
                        scaledTreeItemPageMonitor.close();
                    }
                }
                finally {
                    if (treeItemPagePageMonitor == null) continue;
                    treeItemPagePageMonitor.close();
                }
            }
        }
        finally {
            if (treeItemsMonitor != null) {
                treeItemsMonitor.close();
            }
        }
    }

    protected Tree createTree(long projectId, String refName, org.gitlab4j.api.models.TreeItem tree) {
        return this.getFactory().createTree();
    }

    protected Blob createBlob(long projectId, String refName, org.gitlab4j.api.models.TreeItem blob, ProgressMonitor progressMonitor) throws GitLabApiException {
        RepositoryFile ret = this.createRepositoryFile(projectId, refName, blob, progressMonitor);
        ret.setCommitId(ret.getCommitId());
        ret.setLastCommitId(ret.getLastCommitId());
        ret.setRef(ret.getRef());
        ret.setSize(ret.getSize());
        return ret;
    }

    protected RepositoryFile createRepositoryFile(long projectId, String refName, org.gitlab4j.api.models.TreeItem blob, ProgressMonitor progressMonitor) {
        return this.getFactory().createRepositoryFile();
    }

    public org.gitlab4j.api.models.RepositoryFile loadRepositoryFile(long projectId, String path, String refName) throws GitLabApiException {
        RepositoryFileApi repoFileApi = this.gitLabApi.getRepositoryFileApi();
        return repoFileApi.getFile((Object)projectId, path, refName);
    }
}

