/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.models.gitlab.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.RepositoryApi;
import org.gitlab4j.api.RepositoryFileApi;
import org.gitlab4j.api.models.TreeItem;
import org.nasdanika.common.Util;
import org.nasdanika.models.gitlab.Blob;
import org.nasdanika.models.gitlab.GitLabFactory;
import org.nasdanika.models.gitlab.Tree;

public class GitLabURIHandler
implements URIHandler {
    public static final String GITLAB_URI_SCHEME = "gitlab";
    protected RepositoryFileApi repositoryFileApi;
    protected GitLabApi gitLabApi;
    protected RepositoryApi repositoryApi;

    public GitLabURIHandler(GitLabApi gitLabApi) {
        this.gitLabApi = gitLabApi;
        this.repositoryFileApi = gitLabApi.getRepositoryFileApi();
        this.repositoryApi = gitLabApi.getRepositoryApi();
    }

    public boolean canHandle(URI uri) {
        return GITLAB_URI_SCHEME.equals(uri.scheme());
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        if (Util.isBlank((String)uri.lastSegment())) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMIResourceImpl resource = new XMIResourceImpl(uri);
            try (ByteArrayOutputStream byteArrayOutputStream = baos;){
                Tree tree = GitLabFactory.eINSTANCE.createTree();
                resource.getContents().add((Object)tree);
                List treeItems = this.repositoryApi.getTree(this.getProjectIdOrPath(uri), this.getPath(uri), this.getRef(uri));
                for (TreeItem treeItem : treeItems) {
                    switch (treeItem.getType()) {
                        case TREE: {
                            Tree subTree = GitLabFactory.eINSTANCE.createTree();
                            subTree.setId(treeItem.getId());
                            subTree.setName(treeItem.getName());
                            subTree.setPath(treeItem.getPath());
                            tree.getTreeItems().add((Object)subTree);
                            break;
                        }
                        case BLOB: {
                            Blob blob = GitLabFactory.eINSTANCE.createBlob();
                            blob.setId(treeItem.getId());
                            blob.setName(treeItem.getName());
                            blob.setPath(treeItem.getPath());
                            tree.getTreeItems().add((Object)blob);
                            break;
                        }
                        case COMMIT: {
                            break;
                        }
                    }
                }
            }
            catch (GitLabApiException e) {
                throw new IOException(e);
            }
            resource.save((OutputStream)baos, options);
            return new ByteArrayInputStream(baos.toByteArray());
        }
        try {
            return this.repositoryFileApi.getRawFile(this.getProjectIdOrPath(uri), this.getRef(uri), this.getPath(uri));
        }
        catch (GitLabApiException e) {
            throw new IOException(e);
        }
    }

    protected Object getProjectIdOrPath(URI uri) {
        try {
            return Long.parseLong(uri.authority());
        }
        catch (NumberFormatException e) {
            return uri.authority();
        }
    }

    protected String getRef(URI uri) {
        return uri.segment(0);
    }

    protected String getPath(URI uri) {
        return uri.path().substring(uri.segment(0).length() + 2);
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
        return Collections.emptyMap();
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        return true;
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        return Collections.emptyMap();
    }

    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
        throw new UnsupportedOperationException();
    }
}

