/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.models.gitlab.util;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gitlab4j.api.GitLabApi;
import org.nasdanika.models.gitlab.util.ThrottlingHandler;

public class GitLabApiProvider
implements AutoCloseable {
    private GitLabApi gitLabApi;

    public GitLabApi getGitLabApi() {
        return this.gitLabApi;
    }

    public GitLabApiProvider(String hostUrl, String accessToken) {
        this(new GitLabApi(hostUrl, accessToken));
    }

    public GitLabApiProvider(GitLabApi gitLabApi) {
        this(gitLabApi, new ThrottlingHandler());
    }

    public GitLabApiProvider(String hostUrl, String accessToken, long clientRateLimitWindow, int clientRateLimit) {
        this(new GitLabApi(hostUrl, accessToken), clientRateLimitWindow, clientRateLimit);
    }

    public GitLabApiProvider(GitLabApi gitLabApi, long clientRateLimitWindow, int clientRateLimit) {
        this(gitLabApi, new ThrottlingHandler(clientRateLimitWindow, clientRateLimit));
    }

    public GitLabApiProvider(GitLabApi gitLabApi, Handler throttlingHandler) {
        if (throttlingHandler != null) {
            Level level = Level.FINE;
            throttlingHandler.setLevel(level);
            Logger logger = Logger.getLogger(GitLabApi.class.getName());
            Level loggerLevel = logger.getLevel();
            if (loggerLevel == null || loggerLevel.intValue() > level.intValue()) {
                logger.setLevel(level);
            }
            logger.addHandler(throttlingHandler);
            gitLabApi.enableRequestResponseLogging();
        }
        this.gitLabApi = gitLabApi;
    }

    @Override
    public void close() {
        if (this.gitLabApi != null) {
            this.gitLabApi.close();
        }
    }
}

