/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.models.gitlab;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Status implements Enumerator
{
    INFO(0, "Info", "Info"),
    SUCCESS(1, "Success", "Success"),
    WARNING(2, "Warning", "Warning"),
    ERROR(3, "Error", "Error"),
    FAIL(4, "Fail", "Fail"),
    CANCEL(5, "Cancel", "Cancel");

    public static final int INFO_VALUE = 0;
    public static final int SUCCESS_VALUE = 1;
    public static final int WARNING_VALUE = 2;
    public static final int ERROR_VALUE = 3;
    public static final int FAIL_VALUE = 4;
    public static final int CANCEL_VALUE = 5;
    private static final Status[] VALUES_ARRAY;
    public static final List<Status> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static Status get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Status result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static Status getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Status result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static Status get(int value) {
        switch (value) {
            case 0: {
                return INFO;
            }
            case 1: {
                return SUCCESS;
            }
            case 2: {
                return WARNING;
            }
            case 3: {
                return ERROR;
            }
            case 4: {
                return FAIL;
            }
            case 5: {
                return CANCEL;
            }
        }
        return null;
    }

    private Status(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new Status[]{INFO, SUCCESS, WARNING, ERROR, FAIL, CANCEL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

