/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.models.gitlab;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SquashOption implements Enumerator
{
    NEVER(0, "Never", "Info"),
    ALWAYS(1, "Always", "Always"),
    DEFAULT_ON(2, "DefaultOn", "DefaultOn"),
    DEFAULT_OFF(3, "DefaultOff", "DefaultOff");

    public static final int NEVER_VALUE = 0;
    public static final int ALWAYS_VALUE = 1;
    public static final int DEFAULT_ON_VALUE = 2;
    public static final int DEFAULT_OFF_VALUE = 3;
    private static final SquashOption[] VALUES_ARRAY;
    public static final List<SquashOption> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static SquashOption get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            SquashOption result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static SquashOption getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            SquashOption result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static SquashOption get(int value) {
        switch (value) {
            case 0: {
                return NEVER;
            }
            case 1: {
                return ALWAYS;
            }
            case 2: {
                return DEFAULT_ON;
            }
            case 3: {
                return DEFAULT_OFF;
            }
        }
        return null;
    }

    private SquashOption(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new SquashOption[]{NEVER, ALWAYS, DEFAULT_ON, DEFAULT_OFF};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

