/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.models.gitlab;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MergeMethod implements Enumerator
{
    MERGE(0, "Merge", "Merge"),
    REBASE_MERGE(1, "RebaseMerge", "RebaseMerge"),
    FAST_FORWARD(2, "FastForward", "FastForward");

    public static final int MERGE_VALUE = 0;
    public static final int REBASE_MERGE_VALUE = 1;
    public static final int FAST_FORWARD_VALUE = 2;
    private static final MergeMethod[] VALUES_ARRAY;
    public static final List<MergeMethod> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static MergeMethod get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            MergeMethod result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static MergeMethod getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            MergeMethod result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static MergeMethod get(int value) {
        switch (value) {
            case 0: {
                return MERGE;
            }
            case 1: {
                return REBASE_MERGE;
            }
            case 2: {
                return FAST_FORWARD;
            }
        }
        return null;
    }

    private MergeMethod(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new MergeMethod[]{MERGE, REBASE_MERGE, FAST_FORWARD};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

