/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.models.gitlab;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BuildGitStrategy implements Enumerator
{
    FETCH(0, "Fetch", "Fetch"),
    CLONE(1, "Clone", "Clone");

    public static final int FETCH_VALUE = 0;
    public static final int CLONE_VALUE = 1;
    private static final BuildGitStrategy[] VALUES_ARRAY;
    public static final List<BuildGitStrategy> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static BuildGitStrategy get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            BuildGitStrategy result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static BuildGitStrategy getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            BuildGitStrategy result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static BuildGitStrategy get(int value) {
        switch (value) {
            case 0: {
                return FETCH;
            }
            case 1: {
                return CLONE;
            }
        }
        return null;
    }

    private BuildGitStrategy(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new BuildGitStrategy[]{FETCH, CLONE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

